
#include <tangle.h>
#include <stdlib.h>
#include <glib.h>
#include "createALLknots.h"
#include "check_path.h"
#include "config.h"
#include "create_inkml.h"
#include "read_user_pass_from_file.h"
#include "buttons.h"

#include "../jammo.h"
int i_plus=0; //Should be done private



ClutterActor *avatar;



static gboolean
verify_path (ClutterRectangle *rect, ClutterEvent *event, ClutterActor *container, gpointer data)
{
	 int *pp;
	 int *p_arr = g_malloc(40 * sizeof(int));
	 int i;


	 pp = get_knot_buff_a();
	 for (i=0; i<i_plus; i++) {
		 p_arr[i] =pp[i];
	 }
     //g_print("IPLUS:%d\n", i_plus);
	 int *b;
	 b = (int*)get_user_passwd();

	 int check=0;;
	 //g_print("\nARRAY:%d\n", p_arr[1]);
	 check=compareArrays(p_arr,b,i_plus);

	 if (check==1)
	 {
	 	 g_print("\nWelcome :)\n");
	 	 clutter_actor_show(avatar);
	 	 clutter_actor_hide(container);
	 }else{
 		 g_print("\nWrong pass\n");
 		 clutter_actor_hide(avatar);
     }

	check=0;
	g_free(p_arr);


    //set_knots_buff(); //INITIALIZE THE BUFFER AGAIN
    i_plus=0;
    return TRUE; /* Stop further handling of this event. */
}

static gboolean
on_box_enter (ClutterActor *box,
              ClutterEvent *event,
              ClutterActor *emblem,
              gpointer data)
{
  clutter_actor_animate (emblem, CLUTTER_EASE_IN_SINE, 10,
          //Effects don't work on N900 coz of resources
		  //"rotation-angle-y", 360.0,
          //"rotation-angle-z", 360.0,
          "opacity", 254,
          NULL);

  gfloat x = 0;
  gfloat y = 0;
  clutter_event_get_coords (event, &x, &y);
  set_xy_in_xml(x,y);
  //int emblem_id;
  //emblem_id = clutter_actor_get_gid(emblem);

  /*
  fill_knots_buff(emblem_id,2,i_plus);
  int *pp;
  int p;
  pp = get_knot_buff_a();
  p =pp[0];
  i_plus=i_plus+1;
  g_print(" %d,",emblem_id);
  g_signal_connect (emblem, "button-release-event", G_CALLBACK (verify_path), avatar);
  */
  return TRUE;
}

static gboolean
on_spot_enter(ClutterActor *box,
        ClutterEvent *event,
        ClutterActor *container,
        gpointer data)
{

	//NO OVERFLOW
	if (i_plus == 40)
	{

		initialize_knots_buffer();
		i_plus=0;
	}

	int spot_id;
	spot_id = atoi(clutter_actor_get_name(box));
	/*g_print("%s",clutter_actor_get_name(box));*/
	fill_knots_buff(spot_id,2,i_plus);
	int *pp;
	int p;
	pp = get_knot_buff_a();
	p =pp[0];
	i_plus=i_plus+1;
	//g_print(" %d,",spot_id);
	g_signal_connect (box, "button-release-event", G_CALLBACK (verify_path), container);
	return TRUE;

}

static gboolean
on_box_leave (ClutterActor *box,
              ClutterEvent *event,
              ClutterActor *emblem)
{
  clutter_actor_animate (emblem, CLUTTER_EASE_IN_SINE, 200,
		  	  	  	  	 //Effects don't work on N900
		  	  	  	  	 //CLUTTER_EASE_IN_CUBIC
		  	  	  	  	 //"x", 100.0,
		  	  	  	  	 //"y", 500.0,
		  	  	  	  	 //"rotation-angle-y", 720.0,
		  	  	  	  	 //"rotation-angle-z", 720.0,
                         "opacity", 0,
                         NULL);

  //clutter_actor_destroy(emblem);
  return FALSE;
}

static gboolean
show_points_container(ClutterActor *box,
              ClutterEvent *event,
              ClutterActor *container)
{
	clutter_actor_show(container);
    return FALSE;
}




void login_screen()
{
  //ClutterColor stage_color = { 0x00, 0x00, 0x00, 0xff };
  //ClutterColor actor_cp_color = { 0x00, 0x00, 0x00, 0xff };

  //Initialize buffer for storing activated knots
  initialize_knots_buffer();
  create_ink_head();
  //Initialize clutter






  /* Get the stage created*/
  ClutterActor *stage = jammo_get_actor_by_id("pen-gesture-view");

//jammo_get_actor_by_id("points_box");

  //ClutterLayoutManager *layout = clutter_bin_layout_new (CLUTTER_BIN_ALIGNMENT_CENTER, CLUTTER_BIN_ALIGNMENT_CENTER);
  //ClutterActor *points_box = clutter_box_new (layout);


  // Add Background to the stare: */
  gchar* directory_path0 ="/opt/jammo/password/";
  gchar* filename0="bg.png";
  gchar* path0 = g_build_filename (directory_path0, filename0, NULL);
  ClutterActor *rect0 = clutter_texture_new_from_file (path0, NULL);

  //clutter_actor_set_size (rect0, 800, 480);
  clutter_actor_set_position (rect0, 0, 0);
  clutter_actor_show (rect0);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), rect0);

  //MAKE A CONTAINER
  ClutterActor *point_container = clutter_group_new();
  clutter_actor_set_position (point_container, 0, 0);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), point_container);

  //clutter_actor_show (point_container);
  //clutter_actor_set_size(CLUTTER_ACTOR(main_container),800,480);


  /* Add a rectangle opacity control panel: */
  /*
  ClutterActor *rect_cp = clutter_rectangle_new_with_color (&actor_cp_color);
  clutter_actor_set_size (rect_cp, 300, 440);
  clutter_actor_set_position (rect_cp, 490, 20);
  clutter_actor_set_opacity(rect_cp,1);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), rect_cp);
  */
  //Create Buttons
  button_exit_set(stage);
  button_action_set(stage);
  //button_new_gesture_set(stage);
  button_ok_set(stage);
  //button_next_set(stage);
  //button_back_set(stage);
  button_cancel_set(stage);
  //ClutterActor *avatar;
  avatar=button_avatar_set(stage);
  clutter_actor_hide(avatar);


  //CREATE knots and signals for every knot
  //Only straight lines are permitted
  int ii=0;
  int jj=0;
  int acts=0;
  for (ii=40; ii<370; ii=ii+40)
	  for (jj=40; jj<370; jj=jj+40)
 	  {
		  if((ii==40 || ii==200 || ii==360 || jj==40 || jj==200 || jj==360)) {
			 acts=acts+1;
			 ClutterActor *myKnot[acts];
			 myKnot[acts] = create_knot_with_pos(point_container, ii, jj);
			 g_signal_connect (myKnot[acts],"enter-event", G_CALLBACK (on_box_enter), myKnot[acts]);
			 g_signal_connect (stage,"button-press-event", G_CALLBACK (on_box_leave),  myKnot[acts]);

		  }

 	  }

  ClutterActor *spot11, *spot12, *spot13,
  	  	  	   *spot21, *spot22, *spot23,
  	  	  	   *spot31, *spot32, *spot33;

  spot11 = create_points_with_pos(point_container, 30, 30);
  clutter_actor_set_name(spot11,"1");
  g_signal_connect (spot11,"enter-event", G_CALLBACK (on_spot_enter),point_container);
  spot12 = create_points_with_pos(point_container, 190, 30);
  clutter_actor_set_name(spot12,"2");
  g_signal_connect (spot12,"enter-event", G_CALLBACK (on_spot_enter), point_container);
  spot13=create_points_with_pos(point_container, 350, 30);
  clutter_actor_set_name(spot13,"3");
  g_signal_connect (spot13,"enter-event", G_CALLBACK (on_spot_enter), point_container);
  spot21=create_points_with_pos(point_container, 30, 190);
  clutter_actor_set_name(spot21,"4");
  g_signal_connect (spot21,"enter-event", G_CALLBACK (on_spot_enter), point_container);
  spot22=create_points_with_pos(point_container, 190, 190);
  clutter_actor_set_name(spot22,"5");
  g_signal_connect (spot22,"enter-event", G_CALLBACK (on_spot_enter), point_container);
  spot23=create_points_with_pos(point_container, 350, 190);
  clutter_actor_set_name(spot23,"6");
  g_signal_connect (spot23,"enter-event", G_CALLBACK (on_spot_enter), point_container);
  spot31=create_points_with_pos(point_container, 30, 350);
  clutter_actor_set_name(spot31,"7");
  g_signal_connect (spot31,"enter-event", G_CALLBACK (on_spot_enter), point_container);
  spot32=create_points_with_pos(point_container, 190, 350);
  clutter_actor_set_name(spot32,"8");
  g_signal_connect (spot32,"enter-event", G_CALLBACK (on_spot_enter), point_container);
  spot33=create_points_with_pos(point_container, 350, 350);
  clutter_actor_set_name(spot33,"9");
  g_signal_connect (spot33,"enter-event", G_CALLBACK (on_spot_enter), point_container);


  g_signal_connect(stage,"button-press-event", G_CALLBACK(show_points_container),point_container);
   /* Show the stage: */
  clutter_actor_hide(point_container);

  clutter_actor_show(stage);

}
