/*
 * gems_service_control.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu, Lappeenranta University of Technology
 *
 * Authors: Tommi Kallonen <tommi.kallonen@lut.fi>
 */


#include "gems_service_control.h"
#include "gems_message_functions.h"
#include "communication.h"
#include "../cem/cem.h"


gboolean gems_service_control_process_request(gems_connection* element)
{
	gems_components* data = gems_get_data();
	
	switch(gems_connection_get_16(element,6)) // command
	{
		case CONTROL_MODE:
			gems_service_control_handle_control_mode(data,element);
			break;
		case CONTROL_OK:
			gems_service_control_handle_control_ok(data,element);
			break;
		default:
			break;
	}
	return TRUE;
}

gems_service_control* gems_service_control_init()
{
	gems_service_control* data = (gems_service_control*)g_malloc(sizeof(gems_service_control));
	
	data->enabled = FALSE;

	data->active=FALSE;
	
	data->port = 0;

	return data;
}

void gems_service_control_cleanup()
{
	gems_service_control* data = gems_get_data()->service_control;
	
	
	if(data != NULL)
	{
		g_free(data);
		data = NULL;
	}
}

void gems_service_control_handle_control_mode(gems_components* data, gems_connection* element)
{
	gchar* logmsg = NULL;
	guint position=8;
	gint16 cntrl_type;
	gint16 lock_mode;

	// Control type
	cntrl_type = gems_connection_get_16(element,position);
	position = position + sizeof(gint16);

	// Lock mode
	lock_mode = gems_connection_get_16(element,position);
	position = position + sizeof(gint16);

	// TODO do something with new control mode

	logmsg = g_strdup_printf("gems_service_control_handle_control_mode: got CONTROL_MODE ");
	cem_add_to_log(logmsg,LOG_NETWORK_DEBUG);
	g_free(logmsg);
}

void gems_service_control_handle_control_ok(gems_components* data, gems_connection* element)
{
	gchar* logmsg = NULL;

	logmsg = g_strdup_printf("gems_service_control_handle_control_ok: got CONTROL_OK ");
	cem_add_to_log(logmsg,LOG_NETWORK_DEBUG);
	g_free(logmsg);
}
