/*
 * gems_profile_manager.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu, Lappeenranta University of Technology
 *
 * Authors: Jussi Laakkonen <jussi.laakkonen@lut.fi>
 */

#include "gems_profile_manager.h"
#include "gems.h"

// Login
gboolean gems_profile_manager_login(guint32 userId, gchar* username, gchar* passworddata)
{
	ProfileManager* pm = gems_get_data()->pm;
	if(pm == NULL) return FALSE;
	
	return profilemanager_login(pm,userId);
}

// Logout
gboolean gems_profile_manager_logout()
{
	ProfileManager* pm = gems_get_data()->pm;
	if(pm == NULL) return FALSE;
	return profilemanager_logout(pm);
}

/* PROFILE MANAGER API*/

/* Get userid */
guint32 gems_profile_manager_get_userid(gems_peer_profile* profile)
{
	if(profile == NULL)
	{
		ProfileManager* pm = gems_get_data()->pm;
		if(pm == NULL) return 0;
		return profilemanager_get_userid(pm);
	}
	else return profile->id;
}

/* Get own username */
const gchar* gems_profile_manager_get_username(gems_peer_profile* profile)
{
	if(profile == NULL)
	{
		ProfileManager* pm = gems_get_data()->pm;
		if(pm == NULL) return NULL;
		return profilemanager_get_username(pm);
	}
	else return profile->username;
}

/* Get firstname */
const gchar* gems_profile_manager_get_firstname()
{
	ProfileManager* pm = gems_get_data()->pm;
	if(pm == NULL) return NULL;
	return profilemanager_get_firstname(pm);
}

/* Get lastname */
const gchar* gems_profile_manager_get_lastname()
{
	ProfileManager* pm = gems_get_data()->pm;
	if(pm == NULL) return NULL;
	return profilemanager_get_lastname(pm);
}

/* Get age */
guint16 gems_profile_manager_get_age(gems_peer_profile* profile)
{
	if(profile == NULL)
	{
		ProfileManager* pm = gems_get_data()->pm;
		if(pm == NULL) return 0;
		return profilemanager_get_age(pm);
	}
	else return profile->age;
}

guint16 gems_profile_manager_get_avatar_id(gems_peer_profile* profile)
{
	if(profile == NULL) return 0; // TODO implement avatars ?
	else return profile->age;
}

/* Get points */
guint32 gems_profile_manager_get_points()
{
	ProfileManager* pm = gems_get_data()->pm;
	if(pm == NULL) return 0;
	return profilemanager_get_points(pm);
}

/* Add points */
gboolean gems_profile_manager_add_points(guint32 _value)
{
	ProfileManager* pm = gems_get_data()->pm;
	if(pm == NULL) return FALSE;
	return profilemanager_add_points(pm, _value);
}

/* Remove points */
gboolean gems_profile_manager_remove_points(guint32 _value)
{
	ProfileManager* pm = gems_get_data()->pm;
	if(pm == NULL) return FALSE;
	return profilemanager_remove_points(pm, _value);
}

/* Reset points (set to zero) */
void gems_profile_manager_reset_points()
{
	ProfileManager* pm = gems_get_data()->pm;
	if(pm != NULL) profilemanager_reset_points(pm);
}

gems_peer_profile* gems_profile_get_profile_of_user(guint32 id)
{
	if(gems_get_data()->communication == NULL) return NULL; // Communication not initialized
	gems_connection* element = gems_communication_get_connection_with_userid(gems_get_data()->communication->connections,id);
	
	if(element == NULL) return NULL;
	else return element->profile; // If not set it is still NULL
}
