/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */
#include <tangle.h>
#include <glib-object.h>
#include "startmenu.h"
#include "../jammo.h"
#include "sequencer.h"
#include "gamesmenu.h"
#include "communitymenu.h"

ClutterActor* startmenu_group=NULL;

//go to sequencer
void startmenu_goto_sequencer (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	//tangle_actor_hide_animated(TANGLE_ACTOR(actor));
	start_sequencer("seq.txt");
}

//go to gamesmenu
void startmenu_goto_gamesmenu (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
//	tangle_actor_hide_animated(TANGLE_ACTOR(actor));
	start_gamesmenu();
}

//go to communitymenu
void  startmenu_goto_communitymenu (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
//	tangle_actor_hide_animated(TANGLE_ACTOR(actor));
	start_communitymenu();
}

void init_startmenu() {}

void show_startmenu()
{
	printf("Showing startmenu\n");
	clutter_actor_show (CLUTTER_ACTOR(startmenu_group));

	clutter_actor_queue_relayout(clutter_actor_get_parent(CLUTTER_ACTOR(startmenu_group)));
}

gboolean start_startmenu(gpointer data)
{
	ClutterActor* mainview;

	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);


	startmenu_group = jammo_get_actor_by_id("startmenu-view");
	clutter_actor_show (CLUTTER_ACTOR(startmenu_group));

	return FALSE;
}
