#include <tangle.h>
#include "../../meam/jammo-sequencer.h"
#include "../jammo-track-view.h"
typedef struct _jammo_theme{
	JammoSequencer* sequencer; /*currently used sequencer*/
	ClutterActor* container;  /* All samples and tracks are in here*/
	ClutterActor* save_menu_container;  /* All samples and tracks are in here*/
	JammoTrackView* bottom_track_view;
	JammoTrackView* upper_track_view; //this is not used in 'easy' mode
	gchar* prefix_for_saving; //This will contain theme-name, -variation and easy/advanced-mode
	GList* animation_timelines; /*This is container for animation timelines of samplebuttons*/
	ClutterActor* play_button; /* This is needed when sequencer stops we want change between stop and play images*/
	gboolean only_playing_mode; //When editing this is FALSE. When coming from cupboard, only listen is allowed
} jammo_theme;


jammo_theme* theme_create(const gchar* name, int variation, gboolean only_listening, ClutterActor* play_button);
void theme_stop_all_icon_animations(jammo_theme* theme);
void theme_play_all_icon_animations(jammo_theme* theme);
void delete_theme(jammo_theme* theme);

ClutterActor* theme_give_sample_button_for_this_theme_and_variation_for_this_id(gchar* themename, guint variation, guint id);
