/*
 * jammo-game-level.c
 *
 * This file is part of JamMo.
 *
 * (c) 2010 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

#include "jammo-game-level.h"
#include "jammo-game.h"
#include <string.h>

G_DEFINE_TYPE(JammoGameLevel, jammo_game_level, G_TYPE_OBJECT);

enum {
	PROP_0,
};

typedef struct _GameData {
	gchar* name;
	
	guint completed : 1;
} GameData;

struct _JammoGameLevelPrivate {
	ClutterScript* script;
	GList* game_datas;
	
	GameData* active_game_data;
	JammoGame* active_game;
	guint script_merge_id;
};

static gboolean game_data_has_name(GameData* game_data, const gchar* name);

JammoGameLevel* jammo_game_level_new(ClutterScript* script) {
	JammoGameLevel* game_level;
	
	g_return_val_if_fail(script, NULL);
	
	game_level = JAMMO_GAME_LEVEL(g_object_new(JAMMO_TYPE_GAME_LEVEL, NULL));
	game_level->priv->script = script;

	return game_level;
}

GList* jammo_game_level_get_game_names(JammoGameLevel* game_level) {
	/* TODO */
	
	return NULL;
}

void jammo_game_level_add_game_name(JammoGameLevel* game_level, const gchar* game_name) {
	/* TODO */
}

gboolean jammo_game_level_get_game_completed(JammoGameLevel* game_level, const gchar* game_name) {
	/* TODO */

	return FALSE;
}

void jammo_game_level_set_game_completed(JammoGameLevel* game_level, const gchar* game_name, gboolean is_completed) {
	/* TODO */
}

void jammo_game_level_start_game(JammoGameLevel* game_level, const gchar* game_name) {
	GList* list_item;
/*	GameData* game_data;
	JammoGame* game;
*/	
	g_return_if_fail(!game_level->priv->active_game);
	
	if (!(list_item = g_list_find_custom(game_level->priv->game_datas, game_name, (GCompareFunc)game_data_has_name))) {
		g_critical("A game named '%s' could not be found.", game_name);
	} else {
		/* TODO: continue here! */
	
/*	game_level->priv->active_game = game;
*/
	}
}

void jammo_game_level_stop_game(JammoGameLevel* game_level) {
	g_return_if_fail(game_level->priv->active_game);
	
	clutter_script_unmerge_objects(game_level->priv->script, game_level->priv->script_merge_id);
	
}

static void jammo_game_level_set_property(GObject* object, guint prop_id, const GValue* value, GParamSpec* pspec) {
	JammoGameLevel* game_level;
	
	game_level = JAMMO_GAME_LEVEL(object);

	switch (prop_id) {
		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
			break;
	}
}

static void jammo_game_level_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* pspec) {
        JammoGameLevel* game_level;

	game_level = JAMMO_GAME_LEVEL(object);

        switch (prop_id) {
	        default:
		        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		        break;
        }
}

static void jammo_game_level_finalize(GObject* object) {
	G_OBJECT_CLASS(jammo_game_level_parent_class)->finalize(object);
}

static void jammo_game_level_dispose(GObject* object) {
	G_OBJECT_CLASS(jammo_game_level_parent_class)->dispose(object);
}

static void jammo_game_level_class_init(JammoGameLevelClass* klass) {
	GObjectClass* gobject_class = G_OBJECT_CLASS(klass);

	gobject_class->finalize = jammo_game_level_finalize;
	gobject_class->dispose = jammo_game_level_dispose;
	gobject_class->set_property = jammo_game_level_set_property;
	gobject_class->get_property = jammo_game_level_get_property;

	g_type_class_add_private (gobject_class, sizeof (JammoGameLevelPrivate));
}

static void jammo_game_level_init(JammoGameLevel* game_level) {
	game_level->priv = G_TYPE_INSTANCE_GET_PRIVATE(game_level, JAMMO_TYPE_GAME_LEVEL, JammoGameLevelPrivate);
}

static gboolean game_data_has_name(GameData* game_data, const gchar* name) {

	return strcmp(game_data->name, name) == 0;
}
