/** chum.c is part of JamMo.
License: GPLv2, read more from COPYING

(from D2.4)
"CHUM controls the user interface and will communicate with all other modules. 
It will use MEAM to create music. It will use GEMS to identify and authorize
the user and to send data to other users and teacher's server. It also sends
all the user actions to CEM fo logging/mentor input/game input."
*/

#include <tangle.h>
#include <fcntl.h> //we check some files
#include <string.h> //we use strcmp
#include <pthread.h> // we use threads when debugging
#include <unistd.h>

#include "song.h"

#include "chum.h"


#include "../../cem/cem.h"
#include "../../meam/jammo-meam.h"
#include "../../meam/jammo-sample.h"
#include "../../meam/jammo-editing-track.h"
#include "../../meam/jammo-recording-track.h"
#include "../../meam/jammo-instrument-track.h"
#include "../../meam/jammo-slider-track.h"
#include "../../meam/jammo-playing-track.h"

#include "../../gems/gems.h"

#include "../jammo-mentor.h"
#include "../jammo.h"
#include "gui.h"
#include "singinggame.h"

/*Chum is like state-machine*/
int state_of_chum=SCREEN_WELCOME;
jammo_song* current_song;  /*for karaoke game*/

//This is not same than language from profile (which affects speech of mentor)
//This is only when user wants sing a song in different language.
char* selected_language=NULL;

const char* chum_get_selected_language(){
	return selected_language;
}

void  chum_set_selected_language(const gchar* language){
	if (selected_language)
		g_free(selected_language);
	selected_language = g_strdup(language);
}


static gboolean duetto=TRUE;
void chum_set_duetto(gboolean b){
	duetto=b;
}

gboolean chum_get_duetto(){
	return duetto;
}


//FALSE means advanced_game
static gboolean chum_easy_game = TRUE;
gboolean chum_is_easy_game(){
  return chum_easy_game;
}

void chum_set_easy_game(gboolean b){
	printf("Game level set to %s\n", b ? "easy":"advanced");
	chum_easy_game=b;
}
//This helps logging/debugging state switching
char *name_of_states[] ={ "SCREEN_WELCOME",
                          "SCREEN_PASSWORD_TYPING",
                          "SCREEN_GAME_SELECTION",
                          "SCREEN_THEME_SELECTION",
                          "SCREEN_COMPOSING",
                          "SCREEN_SONG_SELECTION",
                          "SCREEN_SONG_RECORDING",
                          "SCREEN_PLAY_RECORDED",
                          "SCREEN_MIDI_EDITOR",
                          "SCREEN_SEQUENCER",
                          "SCREEN_STARTMENU",
                          "SCREEN_GAMESMENU",
                          "SCREEN_COMMUNITYMENU",
                          "SCREEN_FROM_CUPBOARD"};


gboolean multiplaying=FALSE; 
gint number_of_themes = 0;
gint chum_get_number_of_themes(){
return number_of_themes;
}

int chum_get_state_of_chum(){
return state_of_chum;
}

void chum_set_state_of_chum(int state){
state_of_chum=state;
}






jammo_song* chum_get_current_song(){
	return current_song;
}

void chum_set_current_song(jammo_song* song){
	current_song = song;
}


//for communication interface
JammoSample* chum_add_new_sample_to_track_remote(int a, const gchar* id, guint64 startTime){
return NULL;
}

void chum_remove_sample_from_slot_remote(int a, int slot){
return;
}



//FIXME: this is copy-pasted from singing-game (solo/duetto and language-selection uses same kind of mechanism)
static gulong handler_for_mentor_say_selected;

static void mentor_say_what_is_selected(TangleActor *actor, ClutterActorBox *arg1, gpointer user_data){
	//printf("got '%s'\n",(gchar*)user_data);
	gchar *filepath1;
	filepath1 =  g_strdup_printf("%s_selected.spx", (gchar*)user_data);

	jammo_mentor_speak(jammo_mentor_get_default(), filepath1);
	g_free(filepath1);
	g_signal_handler_disconnect (actor,handler_for_mentor_say_selected);
}


void jammo_easy_changed(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties) {
	ClutterActor* ct =CLUTTER_ACTOR(source);
	const gchar* name = clutter_actor_get_name(ct);
	printf("easy/advanced clicked. get_name: '%s'\n",name);

	TangleButton* tanglebutton = TANGLE_BUTTON(jammo_get_actor_by_id("main-menu-skill-level-button"));

	ClutterActor* view = jammo_get_actor_by_id("main-menu-view");

		if (strcmp(name,"cancel")==0) {
		tangle_button_set_selected(tanglebutton,!tangle_button_get_selected(tanglebutton));
		}

	if (strcmp(name,"easy")==0)
		{
		tangle_button_set_selected(tanglebutton,FALSE);
		chum_set_easy_game(TRUE);
		handler_for_mentor_say_selected=g_signal_connect(view, "show-completed", G_CALLBACK(mentor_say_what_is_selected), "skill_easy");
		}
	else if (strcmp(name,"advanced")==0)
		{
		tangle_button_set_selected(tanglebutton,TRUE);
		chum_set_easy_game(FALSE);
		handler_for_mentor_say_selected=g_signal_connect(view, "show-completed", G_CALLBACK(mentor_say_what_is_selected), "skill_advanced");
		}
	singinggame_force_reinit_songs();

}

