/*
 * StorageAgent.cpp
 *
 *  Created on: 1.11.2009
 *      Author: Japskua
 */

#include <iostream>
#include <sstream>
#include <fstream>
#include <algorithm>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "StorageAgent.h"


using namespace std;

// Constructor
StorageAgent::StorageAgent()
{
	struct stat st;
	if(stat(JAMMOPROFILE,&st) != 0)
	{
		if(mkdir(JAMMOPROFILE,0777) == -1) std::cerr << "StorageAgent::StorageAgent: cannot create profile directory" << std::endl;
	}
}

// Destructor
StorageAgent::~StorageAgent()
{
	// Just to make sure
	profileDetails.clear();
}

// Synchronizes profile data
gboolean StorageAgent::Synchronize()
{
	// TODO: Synchronizing missing
	return TRUE;
}

// Removes the unneccesary lines from the files read
void StorageAgent::Tokenize(const string& str,
			  vector<string>& tokens,
			  const string& delimiters)
{
	// Skip delimiters at beginning.
	string::size_type lastPosition = str.find_first_not_of(delimiters, 0);
	// Find first "non-delimiter".
	string::size_type position  = str.find_first_of(delimiters, lastPosition);

	while (string::npos != position || string::npos != lastPosition)
	{
		// Found a token, add it to the vector.
		tokens.push_back(str.substr(lastPosition, position - lastPosition));
		// Skip delimiters.  Note the "not_of"
		lastPosition = str.find_first_not_of(delimiters, position);
		// Find next "non-delimiter"
		position = str.find_first_of(delimiters, lastPosition);
	}

}

// Retrieves user profile data
gboolean StorageAgent::Retrieve(guint32 userID)
{
	// All the user information is currently saved to a 
	// .csv file, so it is possible to save and edit
	// details 
	
	ifstream profileFile;
	string line;
	string profileCSV;
	
	// change the userID to string
	stringstream user;
	user << userID;
	
	// Append all the neccesary parts to the filename
	profileCSV.append(JAMMOPROFILE);
	profileCSV.append(user.str());
	profileCSV.append(PROFILETYPE);
	
	// Change the string to char* for reading as a file	
	char *pfile = (char*)profileCSV.c_str();
	
	// Open the file containing the profiles
	profileFile.open(pfile);
	
	if (!profileFile)
	{
		//cerr << "Unable to open file!" << endl;
		// Use some default values.
		profileDetails[PROF_PARAM_USERID] = user.str();
		profileDetails[PROF_PARAM_USERNAME] = PROF_PARAM_USERNAME;
		// TODO fix the auth level to correspond the REAL level
		profileDetails[PROF_PARAM_AUTHLEVEL] = "none";
		profileDetails[PROF_PARAM_FIRSTNAME] = PROF_PARAM_FIRSTNAME;
		profileDetails[PROF_PARAM_LASTNAME] = PROF_PARAM_LASTNAME;
		profileDetails[PROF_PARAM_POINTS] = "0";
		profileDetails[PROF_PARAM_AGE] = "0";
		return FALSE;
	}

	// Get the line and remove the ,
	getline (profileFile, line);
	
	//cout << line << endl;
	
	// Create a vector to hold the user info
	// and take the unneccesary markups off
	vector<string> tokens;
	Tokenize(line, tokens, ",");
	
	// Save all the details to profileDetails container
	profileDetails[PROF_PARAM_USERID] = tokens[0];
	profileDetails[PROF_PARAM_USERNAME] = tokens[1];
	profileDetails[PROF_PARAM_AUTHLEVEL] = tokens[2];
	profileDetails[PROF_PARAM_FIRSTNAME] = tokens[3];
	profileDetails[PROF_PARAM_LASTNAME] = tokens[4];
	profileDetails[PROF_PARAM_POINTS] = tokens[5];
	profileDetails[PROF_PARAM_AGE] = tokens[6];
		
	// Close the file
	profileFile.close();

	return TRUE;
}

// Stores user profile data
gboolean StorageAgent::Store(guint32 userID)
{
	// TODO:  Store function for profile saving
	// Since there is no real database yet, this
	// uses .csv text file :-D Yippii!

	ofstream profileFile;
	string line;
	string profileCSV;
	
	// change the userID to string
	stringstream user;
	user << userID;
	
	// Append all the neccesary parts to the filename
	profileCSV.append(JAMMOPROFILE);
	profileCSV.append(user.str());
	profileCSV.append(PROFILETYPE);
	
	// Change the string to char* for reading as a file	
	char *pfile = (char*)profileCSV.c_str();
	
	// cout << "STORE!" << endl;
	// Open the file containing the profiles, empty the previous
	// one just to be sure that there is no more than 1 line.
	profileFile.open(pfile, ios::trunc);
	if (!profileFile)
	{
		//cerr << "Unable to open file!" << endl;	
		// TODO report what kind of error
		return FALSE;
	}

	// Save all the details to a string
	string details = profileDetails[PROF_PARAM_USERID] + "," +
		profileDetails[PROF_PARAM_USERNAME] + "," +
	  profileDetails[PROF_PARAM_AUTHLEVEL] + "," +
	  profileDetails[PROF_PARAM_FIRSTNAME] + "," +
	  profileDetails[PROF_PARAM_LASTNAME] + "," + 
	  profileDetails[PROF_PARAM_POINTS] + "," +
	  profileDetails[PROF_PARAM_AGE];
	
	// Write the string details to a file
	profileFile << details << endl;
	// and close the file
	profileFile.close();

	return TRUE;
}

string StorageAgent::getDetails()
{
	// A variable where the profileListing is saved
	string profileListing;
	// Iterator goes through all the profile information
	// and saves everything to the profileListing
	for (profileIterator = profileDetails.begin();
			profileIterator != profileDetails.end(); ++profileIterator)
	{
		profileListing += profileIterator->first + "=" + profileIterator->second + ",";
	}
	// ProfileListing is returned
	//cout << "StorageAgent::getDetails: details returned." << endl;
	return profileListing;

}

// Get one detail
string StorageAgent::getDetail(string& detail)
{
	// Check if such detail exists
	if( (profileIterator = profileDetails.find(detail)) == profileDetails.end())
	{
		return "";
	}
	else return profileDetails[detail];
}

gboolean StorageAgent::setDetails(string& detail, string& newValue)
{
	// The iterator goes through the profile details saved in the map
	// If there is no detail the user tries to edit, it will inform the user
	if ( (profileIterator = profileDetails.find(detail)) == profileDetails.end() )
		{
			//cout << "StorageAgent::setDetails: no " << detail << "-parameter" << endl;
			return FALSE;
		}
	// Else change the detail to the new wanted value
	else
	{
		profileDetails[detail] = newValue;
	}

	return TRUE;
}

gboolean StorageAgent::clearDetails()
{
	// Clears the map to be empty
	profileDetails.clear();
	return TRUE;
}

