/*
 * jammo-track-view.h
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

#ifndef __JAMMO_TRACK_VIEW_H__
#define __JAMMO_TRACK_VIEW_H__

#include <tangle.h>
#include "../meam/jammo-editing-track.h"
#include "jammo-sample-button.h"

#define JAMMO_TYPE_TRACK_VIEW (jammo_track_view_get_type())
#define JAMMO_TRACK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), JAMMO_TYPE_TRACK_VIEW, JammoTrackView))
#define JAMMO_IS_TRACK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), JAMMO_TYPE_TRACK_VIEW))
#define JAMMO_TRACK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), JAMMO_TYPE_TRACK_VIEW, JammoTrackViewClass))
#define JAMMO_IS_TRACK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), JAMMO_TYPE_TRACK_VIEW))
#define JAMMO_TRACK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), JAMMO_TYPE_TRACK_VIEW, JammoTrackViewClass))

typedef struct _JammoTrackViewPrivate JammoTrackViewPrivate;

typedef struct _JammoTrackView {
	TangleDroppableActor parent_instance;
	JammoTrackViewPrivate* priv;
} JammoTrackView;

typedef struct _JammoTrackViewClass {
	TangleDroppableActorClass parent_class;
} JammoTrackViewClass;

GType jammo_track_view_get_type(void) G_GNUC_CONST;

ClutterActor* jammo_track_view_new(JammoEditingTrack* track, guint n_slots, guint64 slot_duration, gfloat slot_width, gfloat slot_height);
ClutterActor* jammo_track_view_new_peer(JammoEditingTrack* track, guint n_slots, guint64 slot_duration, gfloat slot_width, gfloat slot_height);

void jammo_track_view_remove_jammo_sample_button_from_slot(JammoTrackView* track_view, guint asked_slot);
void jammo_track_view_add_jammo_sample_button(JammoTrackView* track_view, JammoSampleButton* sample_button, guint slot);
guint jammo_track_view_get_sample_button_slot(JammoTrackView* track_view, JammoSampleButton* sample_button);

gboolean jammo_track_view_get_editing_enabled(JammoTrackView* track_view);
void jammo_track_view_set_editing_enabled(JammoTrackView* track_view, gboolean editing_enabled);

#endif
