/**sequencer_general.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is part of the sequencer.
 */
#include <math.h> //fabs
#include <glib-object.h>
#include <clutter/clutter.h>
#include <tangle.h>
#include <string.h>
#include <stdlib.h>

#include "sequencer_general.h"
#include "sequencer.h"

ClutterActor* jammo_get_actor_by_id(const char* id); /*defined in jammo.c*/

//dragging
gboolean is_dragging;
gint x_start_of_dragging, y_start_of_dragging, x_drag_offset, y_drag_offset;
gint height, pos_0_y, pos_1_y, pos_2_y;
ClutterActor* tempo_switch_positions[3];
ClutterActor* pitch_switch_positions[3];
ClutterActor* tempo_switch_area;
ClutterActor* pitch_switch_area;

ClutterActor *dragging = NULL;		     /*object which is currently dragged*/

static void object_pressed (ClutterActor *actor, ClutterEvent *event, gpointer data) {
	gfloat x_start_of_dragging_f,y_start_of_dragging_f;
	clutter_event_get_coords (event, &x_start_of_dragging_f, &y_start_of_dragging_f);

	x_start_of_dragging=(gint)x_start_of_dragging_f;
	y_start_of_dragging=(gint)y_start_of_dragging_f;

	dragging=actor;// puts the actor clicked to the dragging actor
	x_drag_offset = (clutter_actor_get_x (CLUTTER_ACTOR(dragging)) - (int)x_start_of_dragging);
	y_drag_offset = (clutter_actor_get_y (CLUTTER_ACTOR(dragging)) - (int)y_start_of_dragging);

	//even this object is not focused it still gets the mouse events
	clutter_grab_pointer(CLUTTER_ACTOR(actor));
}

static void sequencer_general_set_tempo_switch_position(found)
{
	// stub for setting switch, call MEAM or jammosequencer api form here
	// found is position as 0, top, 1, mid and 2 is bottom
}

static void sequencer_general_set_pitch_switch_position(found)
{
	// stub for setting switch, call MEAM or jammosequencer api form here
	// found is position as 0, top, 1, mid and 2 is bottom
}

static void object_released (ClutterActor *actor, ClutterEvent *event, gpointer data) {
	//Just to be sure.
	if (dragging == NULL){
		printf("dragging == NULL\n");
		return;
	}
	clutter_ungrab_pointer(); //ungrab
	dragging = NULL;

	gfloat actor_x = 0.0;
	gfloat actor_y = 0.0;

	clutter_actor_get_position (CLUTTER_ACTOR(actor), &actor_x, &actor_y);

	ClutterActor** switch_positions = NULL;
	G_CONST_RETURN gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(actor));
	//printf("name is '%s'\n",name);

	if (name == NULL)
	{
		return;
	}

	if (strcmp( name, "tempo_switch_button") == 0)
		{
			//printf("tempo\n");
			switch_positions = tempo_switch_positions;
		}
	else //Not tempo, must be pitch
		{
			//printf("pitch\n");
			switch_positions = pitch_switch_positions;
		}

	gfloat distance = 0.0;
	gint i = 0;
	gint found = -1;
	for (i = 0; i < 3; i++) //magic switch position count
	{
		gfloat position_x = 0.0;
		gfloat position_y = 0.0;
		clutter_actor_get_position (CLUTTER_ACTOR(switch_positions[i]), &position_x, &position_y);
		if (fabs(position_y - actor_y) < distance || found == -1)
		{
			found = i;
			distance = fabs(position_y - actor_y);
		}
	}
	if (found != -1)
	{
		gfloat position_x = 0.0;
		gfloat position_y = 0.0;
		clutter_actor_get_position (CLUTTER_ACTOR(switch_positions[found]), &position_x, &position_y);
		//		clutter_actor_set_position (CLUTTER_ACTOR(actor), position_x, position_y);

		clutter_actor_animate(CLUTTER_ACTOR(actor),
				CLUTTER_EASE_IN_OUT_CUBIC, 200, "x", position_x, "y", position_y, NULL);
		if (switch_positions == tempo_switch_positions)
			sequencer_general_set_tempo_switch_position(found);
		else if (switch_positions == pitch_switch_positions)
			sequencer_general_set_pitch_switch_position(found);
	}
}

static void motion_on_object(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	gfloat x_mouse_position_f, y_mouse_position_f;
	if (CLUTTER_IS_ACTOR(dragging) && dragging != NULL) {
		clutter_event_get_coords (event,&x_mouse_position_f, &y_mouse_position_f);
		//printf("X=%f, Y=%f\n",x_mouse_position, y_mouse_position);
		gint new_x, new_y;
		gint x_mouse_position=(gint)x_mouse_position_f;
		gint y_mouse_position=(gint)y_mouse_position_f;
		new_x=x_mouse_position + x_drag_offset;
		new_y=y_mouse_position + y_drag_offset;

		ClutterActor* switch_area = NULL;
		G_CONST_RETURN gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(actor));
		if (name != NULL)
		{
			if (strcmp( name, "tempo_switch_button") == 0)
			{
				switch_area = tempo_switch_area;
			}
			else if ( strcmp( name, "pitch_switch_button") == 0)
			{
				switch_area = pitch_switch_area;
			}
			else
			{
				// error, fail?
			}
		}
		else
		{
			// couldn't get name, fail?
		}

		gfloat area_x = 0;
		gfloat area_y = 0;
		gfloat area_width = 0;
		gfloat area_height = 0;

		clutter_actor_get_position (CLUTTER_ACTOR(switch_area), &area_x, &area_y);
		clutter_actor_get_size (CLUTTER_ACTOR(switch_area), &area_width, &area_height);
		if (new_x > area_x)
			new_x = area_x;
		else if (new_x < area_x)
			new_x = area_x;
		if (new_y > area_y+area_height)
			new_y = area_y+area_height;
		else if (new_y < area_y)
			new_y = area_y;
		clutter_actor_set_position (CLUTTER_ACTOR(dragging), new_x, new_y);
	}
}

/*
 * CallBack for JSON
 */
void fullsequencer_general_arrow_clicked (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
printf("up\n");
sequencer_change_to_sequencer_view(NULL,NULL);
}


void sequencer_general_tune_containers()
{

	tempo_switch_positions[0] = jammo_get_actor_by_id("tempo_switch_position_0");
	tempo_switch_positions[1] = jammo_get_actor_by_id("tempo_switch_position_1");
	tempo_switch_positions[2] = jammo_get_actor_by_id("tempo_switch_position_2");
	tempo_switch_area = jammo_get_actor_by_id("tempo_switch_area");
	ClutterActor* tempo_switch = jammo_get_actor_by_id("tempo_switch");

	clutter_actor_set_reactive(tempo_switch, TRUE);
	g_signal_connect (tempo_switch, "button-press-event", G_CALLBACK (object_pressed), NULL);
	g_signal_connect (tempo_switch, "button-release-event", G_CALLBACK (object_released), NULL);
	g_signal_connect (tempo_switch, "motion-event", G_CALLBACK (motion_on_object), NULL);


	pitch_switch_positions[0] = jammo_get_actor_by_id("pitch_switch_position_0");
	pitch_switch_positions[1] = jammo_get_actor_by_id("pitch_switch_position_1");
	pitch_switch_positions[2] = jammo_get_actor_by_id("pitch_switch_position_2");
	pitch_switch_area = jammo_get_actor_by_id("pitch_switch_area");
	ClutterActor* pitch_switch = jammo_get_actor_by_id("pitch_switch");

	clutter_actor_set_reactive(pitch_switch, TRUE);
	g_signal_connect (pitch_switch, "button-press-event", G_CALLBACK (object_pressed), NULL); 
	g_signal_connect (pitch_switch, "button-release-event", G_CALLBACK (object_released), NULL);
	g_signal_connect (pitch_switch, "motion-event", G_CALLBACK (motion_on_object), NULL);
}
