/**jammo-texture.ch is part of JamMo.
License: GPLv2, read more from COPYING
*/

#ifndef __JAMMO_TEXTURE_H__
#define __JAMMO_TEXTURE_H__

#include <clutter/clutter.h>
#include "../meam/jammo-sample.h"

#define JAMMO_TYPE_TEXTURE (jammo_texture_get_type ())
#define JAMMO_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), JAMMO_TYPE_TEXTURE, JammoTexture))
#define JAMMO_IS_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), JAMMO_TYPE_TEXTURE))
#define JAMMO_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), JAMMO_TEXTURE, JammoTextureClass))
#define JAMMO_IS_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), JAMMO_TYPE_TEXTURE))
#define JAMMO_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), JAMMO_TYPE_TEXTURE, JammoTextureClass))

typedef struct _JammoTexturePrivate JammoTexturePrivate;

typedef struct _JammoTexture
{
	ClutterTexture parent_instance;
	JammoTexturePrivate* priv;
} JammoTexture;

typedef struct _JammoTextureClass
{
	ClutterTextureClass parent_class;
} JammoTextureClass;

GType jammo_texture_get_type(void);

JammoTexture* jammo_texture_new();
void jammo_texture_set_sound_file_name(JammoTexture* texture, const gchar* sound_file);
const gchar* jammo_texture_get_sound_file_name(JammoTexture* texture);

void jammo_texture_set_sample(JammoTexture* texture, JammoSample* sample);
JammoSample* jammo_texture_get_sample(JammoTexture* texture);

#endif /* __JAMMO_TEXTURE_H__ */
