/*
 * jammo-slider-track.h
 *
 * This file is part of JamMo.
 *
 * (c) 2009 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */
 
#ifndef __JAMMO_SLIDER_TRACK_H__
#define __JAMMO_SLIDER_TRACK_H__

#include <glib.h>
#include <glib-object.h>
#include "jammo-track.h"

#define JAMMO_TYPE_SLIDER_TRACK (jammo_slider_track_get_type ())
#define JAMMO_SLIDER_TRACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), JAMMO_TYPE_SLIDER_TRACK, JammoSliderTrack))
#define JAMMO_IS_SLIDER_TRACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), JAMMO_TYPE_SLIDER_GTRACK))
#define JAMMO_SLIDER_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), JAMMO_TYPE_SLIDER_TRACK, JammoSliderTrackClass))
#define JAMMO_IS_SLIDER_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), JAMMO_TYPE_SLIDER_TRACK))
#define JAMMO_SLIDER_TRACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), JAMMO_TYPE_SLIDER_TRACK, JammoSliderTrackClass))

typedef struct _JammoSliderTrackPrivate JammoSliderTrackPrivate;

typedef struct _JammoSliderTrack {
	JammoTrack parent_instance;
	JammoSliderTrackPrivate* priv;
} JammoSliderTrack;

typedef struct _JammoSliderTrackClass {
	JammoTrackClass parent_class;
} JammoSliderTrackClass;

GType jammo_slider_track_get_type(void);

typedef enum {
		JAMMO_SLIDER_TYPE_ORGAN,
		JAMMO_SLIDER_TYPE_FM_MODULATION,
		JAMMO_SLIDER_TYPE_KARPLUS,
		JAMMO_SLIDER_TYPE_DUMMY, //Keep this last
} JammoSliderType;

JammoSliderTrack* jammo_slider_track_new(JammoSliderType slider_type);

void jammo_slider_track_set_frequency(JammoSliderTrack* slider_track,int frequency);
void jammo_slider_track_set_state(JammoSliderTrack* slider_track,gboolean state);

#endif
