/**sequencer_sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is part of the sequencer.
 */
#include <glib-object.h>
#include <clutter/clutter.h>
#include <string.h>
#include <stdlib.h>
#include <tangle.h>

#include "jammo-texture.h"
#include "../chum/jammo-track-view.h"

#include "sequencer_sequencer.h"
#include "config.h"

enum {
	SEQUENCER_STATE_MOVING = 0,
			SEQUENCER_STATE_LOOP,
			SEQUENCER_STATE_SEQUENCER,
			SEQUENCER_STATE_GENERAL,
			LOOP_ROLL_READY,
			LOOP_ROLL_MOVING,
			SEQUENCER_STATE_PLAYING,
			SEQUENCER_STATE_AUDIO_RECORD

};
int sequencer_state = SEQUENCER_STATE_SEQUENCER;

ClutterActor *BUTTON_SEQUENCER_PLAY;
ClutterActor *BUTTON_SEQUENCER_PLAY_STOP;
ClutterActor *BUTTON_SEQUENCER_HOME;
ClutterActor *BUTTON_SEQUENCER_WORKSHOP;
ClutterActor *BUTTON_SEQUENCER_MENTOR;
ClutterActor *BUTTON_SEQUENCER_AUDIO_RECORD;
ClutterActor *BUTTON_SEQUENCER_AUDIO_RECORD_STOP;
ClutterActor *BUTTON_SEQUENCER_METRONOME;
ClutterActor *BUTTON_SEQUENCER_METRONOME_STOP;
ClutterActor *BUTTON_SEQUENCER_MUTE[6];
ClutterActor *BUTTON_SEQUENCER_VOLUME[6];
ClutterActor *TEXTURE_VOLUME_BACKGROUND;
ClutterActor *BUTTON_VOLUME_SLIDER;

gint VOLUME_MAX = 100; //? FIX

gboolean BUTTON_SEQUENCER_MUTE_STATES[6] = {0,0,0,0,0,0}; //0=mute off, 1=mute on
gint SEQUENCER_VOLUME_STATES[6] = {50,50,50,50,50,50}; //min 0, max=VOLUME_MAX
gint BUTTON_SEQUENCER_VOLUME_ACTIVE = -1; //which volume button is pressed down

gboolean volume_slider_is_dragging = FALSE;
gboolean volume_background_is_dragging = FALSE;

TangleActor *tangleTesti;


static gboolean set_sequencer_state_play(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_PLAY);

	sequencer_state = SEQUENCER_STATE_PLAYING;

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_PLAY_STOP);

	return TRUE;
}

static gboolean set_sequencer_state_play_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_PLAY_STOP);

	sequencer_state = SEQUENCER_STATE_SEQUENCER;

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_PLAY);

	return TRUE;
}

ClutterAnimation * animate_buttonpress_release(ClutterActor *actor) {
	ClutterAnimation *anim = clutter_actor_animate (actor,          /* the actor to animate */
				CLUTTER_LINEAR, /* the easing mode */
				100,           /* the duration of the animation */
				"scale-x", 1.0, /* final horizontal scaling factor */
				"scale-y", 1.0, /* final vertical scaling factor */
				"scale-gravity",CLUTTER_GRAVITY_CENTER,
				NULL);
	return anim;
}

ClutterAnimation * animate_buttonpress_down(ClutterActor *actor) {
	ClutterAnimation *anim = clutter_actor_animate (actor,          /* the actor to animate */
				CLUTTER_LINEAR, /* the easing mode */
				100,           /* the duration of the animation */
				"scale-x", 0.80, /* final horizontal scaling factor */
				"scale-y", 0.80, /* final vertical scaling factor */
				"scale-gravity",CLUTTER_GRAVITY_CENTER,
				NULL);
	return anim;
}

static gboolean set_sequencer_state_return_home(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	animate_buttonpress_release(BUTTON_SEQUENCER_HOME);

	return TRUE;
}

static gboolean set_sequencer_state_workshop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	animate_buttonpress_release(BUTTON_SEQUENCER_WORKSHOP);

	return TRUE;
}

static gboolean set_sequencer_state_mentor(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	animate_buttonpress_release(BUTTON_SEQUENCER_MENTOR);

	return TRUE;
}

static gboolean set_sequencer_state_audio_record(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_AUDIO_RECORD);

	sequencer_state = SEQUENCER_STATE_AUDIO_RECORD;

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_AUDIO_RECORD_STOP);

	return TRUE;
}

static gboolean set_sequencer_state_audio_record_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_AUDIO_RECORD_STOP);

	sequencer_state = SEQUENCER_STATE_SEQUENCER;

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_AUDIO_RECORD);

	return TRUE;
}


static gboolean set_sequencer_state_metronome_on(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_METRONOME);

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_METRONOME_STOP);

	return TRUE;
}

static gboolean set_sequencer_state_metronome_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_hide (BUTTON_SEQUENCER_METRONOME_STOP);

	//Show stop-button
	clutter_actor_show(BUTTON_SEQUENCER_METRONOME);

	return TRUE;
}


/*
 * Event for pressing sequencer view play button
 */
static gboolean pressed_sequencer_button_play(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	set_sequencer_state_play(NULL,NULL,NULL);
	//printf("Play-Button pressed\n");

	return TRUE;
}

/*
 * Event for pressing sequencer view play-stop button
 */
static gboolean pressed_sequencer_button_play_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	//	g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_play_stop), NULL);
	set_sequencer_state_play_stop(NULL,NULL,NULL);

	//printf("Play-Button pressed\n");

	return TRUE;
}




static gboolean pressed_sequencer_button_home(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	ClutterAnimation *anim = animate_buttonpress_down(actor);

	g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_return_home), NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_workshop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	ClutterAnimation *anim = animate_buttonpress_down(actor);

	g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_workshop), NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_mentor(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	ClutterAnimation *anim = animate_buttonpress_down(actor);

	g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_mentor), NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_audio_record(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	set_sequencer_state_audio_record(NULL,NULL,NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_audio_record_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	set_sequencer_state_audio_record_stop(NULL,NULL,NULL);

	return TRUE;
}


static gboolean pressed_sequencer_button_metronome(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	set_sequencer_state_metronome_on(NULL,NULL,NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_metronome_stop(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	set_sequencer_state_metronome_stop(NULL,NULL,NULL);

	return TRUE;
}

static gboolean pressed_sequencer_button_mute(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	int num = GPOINTER_TO_INT(data);

	//if mute is off, set it on
	if (BUTTON_SEQUENCER_MUTE_STATES[num] == 0) {

		ClutterAnimation *anim = animate_buttonpress_down(actor);

		//Shade button

	}

	//if mute is on, set it off
	if (BUTTON_SEQUENCER_MUTE_STATES[num] == 1) {

		ClutterAnimation *anim = animate_buttonpress_release(actor);

	}

	//Change mute state to opposite
	BUTTON_SEQUENCER_MUTE_STATES[num] = !BUTTON_SEQUENCER_MUTE_STATES[num];

	return TRUE;
}


void set_volume_slider_position_by_state(gint state) {

	gfloat position_x_volume_background = 0.0;
	gfloat position_y_volume_background = 0.0;
	get_volume_background_coords(&position_x_volume_background, &position_y_volume_background);

	//get volume background size
	gfloat volume_background_width = 0;
	gfloat volume_background_height = 0;
	clutter_actor_get_size (TEXTURE_VOLUME_BACKGROUND, &volume_background_width, &volume_background_height);

	//get volume slider size
	gfloat volume_slider_width = 0;
	gfloat volume_slider_height = 0;
	clutter_actor_get_size (BUTTON_VOLUME_SLIDER, &volume_slider_width, &volume_slider_height);

	//vertical range of volume background
	gfloat v_range = volume_background_height - volume_slider_height;

	//volume range is 0..VOLUME_MAX
	//calculate slider position
	gfloat position_x_volume_slider = position_x_volume_background + 2;
	gfloat position_y_volume_slider = position_y_volume_background + (v_range / VOLUME_MAX * state);

	clutter_actor_set_position (BUTTON_VOLUME_SLIDER, position_x_volume_slider, position_y_volume_slider);

}

int get_actor_height(ClutterActor *actor) {

	gfloat width = 0;
	gfloat height = 0;

	clutter_actor_get_size (actor, &width, &height);

	int retval = (gint)height;
	return retval;

}

void get_volume_background_coords(gfloat *position_x, gfloat *position_y) {

		gfloat position_x_volume_background;
		gfloat position_y_volume_background;

		clutter_actor_get_position (BUTTON_SEQUENCER_VOLUME[BUTTON_SEQUENCER_VOLUME_ACTIVE], &position_x_volume_background,
				&position_y_volume_background);

		//get the width of volume button
		gfloat volume_button_width = 0;
		gfloat volume_button_height = 0;

		clutter_actor_get_size (BUTTON_SEQUENCER_VOLUME[BUTTON_SEQUENCER_VOLUME_ACTIVE], &volume_button_width, &volume_button_height);

		position_x_volume_background += volume_button_width + 2;

		*position_x = position_x_volume_background;
		*position_y = position_y_volume_background;

}

static gboolean pressed_sequencer_button_volume(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	int num = GPOINTER_TO_INT(data);

	//if selected button was in normal state (not pressed down)
	if (num != BUTTON_SEQUENCER_VOLUME_ACTIVE) {

		//release last active volume button
		if (BUTTON_SEQUENCER_VOLUME_ACTIVE >= 0) {
			/*ClutterAnimation *anim = */

			animate_buttonpress_release(BUTTON_SEQUENCER_VOLUME[BUTTON_SEQUENCER_VOLUME_ACTIVE]);
		}

		//set new active volume button
		BUTTON_SEQUENCER_VOLUME_ACTIVE = num;

		//Push selected volume button down

		//use general animate function
		animate_buttonpress_down(BUTTON_SEQUENCER_VOLUME[BUTTON_SEQUENCER_VOLUME_ACTIVE]);

		//Open volume slider next to selected button
		clutter_actor_show(BUTTON_VOLUME_SLIDER);
		clutter_actor_show(TEXTURE_VOLUME_BACKGROUND);

		//get selected volume button coords
		gfloat position_x_volume_background = 0.0;
		gfloat position_y_volume_background = 0.0;
		get_volume_background_coords(&position_x_volume_background, &position_y_volume_background);

		//set volume background to new position
		clutter_actor_set_position (TEXTURE_VOLUME_BACKGROUND, position_x_volume_background, position_y_volume_background);

		//set the volume slider in its current position
		set_volume_slider_position_by_state(SEQUENCER_VOLUME_STATES[BUTTON_SEQUENCER_VOLUME_ACTIVE]);

	} else {


		//selected volume button was down - set it to normal state
		/*ClutterAnimation *anim = */
		//use general animate function
		animate_buttonpress_release(BUTTON_SEQUENCER_VOLUME[num]);

		BUTTON_SEQUENCER_VOLUME_ACTIVE = -1;

		clutter_actor_hide(BUTTON_VOLUME_SLIDER);
		clutter_actor_hide(TEXTURE_VOLUME_BACKGROUND);
	}

	return TRUE;
}

void move_volume_slider(ClutterEvent *event) {

	gfloat x_mouse_f,y_mouse_f;
	clutter_event_get_coords (event, &x_mouse_f, &y_mouse_f);

	//get selected volume button coords
	gfloat position_x_volume_background_f = 0.0;
	gfloat position_y_volume_background_f = 0.0;
	get_volume_background_coords(&position_x_volume_background_f, &position_y_volume_background_f);

	gint position_x_volume_background = (gint)position_x_volume_background_f;
	gint position_y_volume_background = (gint)position_y_volume_background_f;

	gint new_x, new_y;

	new_x=position_x_volume_background + 2 ;
	new_y=(gint)y_mouse_f - get_actor_height(BUTTON_VOLUME_SLIDER) / 2;;

	//Check top and bottom edges
	gint slide_width = get_actor_height(TEXTURE_VOLUME_BACKGROUND) - get_actor_height(BUTTON_VOLUME_SLIDER);

	gint top_edge = position_y_volume_background;
	gint bottom_edge = position_y_volume_background + slide_width;

	if (new_y < top_edge) new_y = top_edge;
	if (new_y > bottom_edge) new_y = bottom_edge;

	gint new_volume_state = VOLUME_MAX * (new_y - position_y_volume_background) / slide_width;

	//update volume state
	SEQUENCER_VOLUME_STATES[BUTTON_SEQUENCER_VOLUME_ACTIVE] = new_volume_state;

	clutter_actor_set_position (CLUTTER_ACTOR(BUTTON_VOLUME_SLIDER), new_x, new_y);
}

static void pressed_sequencer_volume_background (JammoTexture *actor, ClutterEvent *event, gpointer data) {

	volume_background_is_dragging = TRUE;
	clutter_grab_pointer(CLUTTER_ACTOR(actor));

	move_volume_slider(event);
}

static void pressed_sequencer_button_volume_slider (JammoTexture *actor, ClutterEvent *event, gpointer data) {

	volume_slider_is_dragging = TRUE;

	clutter_grab_pointer(CLUTTER_ACTOR(actor));

	move_volume_slider(event);

}

static void released_sequencer_button_volume_slider (JammoTexture *actor, ClutterEvent *event, gpointer data) {

	volume_slider_is_dragging = FALSE;
	clutter_ungrab_pointer();

}

static void released_sequencer_volume_background (JammoTexture *actor, ClutterEvent *event, gpointer data) {

	volume_background_is_dragging = FALSE;
	clutter_ungrab_pointer();

}

static void motion_sequencer_volume_background (JammoTexture *actor, ClutterEvent *event, gpointer data) {

	if (volume_background_is_dragging) {

		move_volume_slider(event);

	}

}

static void motion_sequencer_button_volume_slider (JammoTexture *actor, ClutterEvent *event, gpointer data) {

	if (volume_slider_is_dragging) {

		move_volume_slider(event);

	}

}

void trashbin_clicked(TangleAction *action, GObject *source, const gchar *trigger,
TangleProperties *properties) {
        /* Tee jotain jännää täällä; eihän noista parametreistakaan
           tarvitse välttämättä välittää... */
	printf("Nappulaa klikattu\n");

}

ClutterActor *create_sequencer_container() {

	//Some default values. TODO
	int number_of_slots = 40;
	int duration_of_one_slot = 1000000000L; //FIXME:One second. This affects when we have cursor moving.
	int width_of_slot = 40;
	
	ClutterActor *sequencer_view = config_get_configured_actor("sequencer", "sequencer_view");
	JammoEditingTrack *keyboard_editing_track = jammo_editing_track_new();
	ClutterActor *keyboard_track_view = CLUTTER_ACTOR(jammo_track_view_new(keyboard_editing_track,number_of_slots,duration_of_one_slot,width_of_slot));

	JammoEditingTrack *drum_editing_track = jammo_editing_track_new();
	ClutterActor *drum_track_view = CLUTTER_ACTOR(jammo_track_view_new(drum_editing_track,number_of_slots,duration_of_one_slot,width_of_slot));

	JammoEditingTrack *slider_editing_track = jammo_editing_track_new();
	ClutterActor *slider_track_view = CLUTTER_ACTOR(jammo_track_view_new(slider_editing_track,number_of_slots,duration_of_one_slot,width_of_slot));

	JammoEditingTrack *audio_editing_track = jammo_editing_track_new();
	ClutterActor *audio_track_view = CLUTTER_ACTOR(jammo_track_view_new(audio_editing_track,number_of_slots,duration_of_one_slot,width_of_slot));

	JammoEditingTrack *loop_editing_track = jammo_editing_track_new();
	ClutterActor *loop_track_view = CLUTTER_ACTOR(jammo_track_view_new(loop_editing_track,number_of_slots,duration_of_one_slot,width_of_slot));

	JammoEditingTrack *backing_editing_track = jammo_editing_track_new();
	ClutterActor *backing_track_view = CLUTTER_ACTOR(jammo_track_view_new(backing_editing_track,number_of_slots,duration_of_one_slot,width_of_slot));

	clutter_actor_set_position(keyboard_track_view, 194.0, 48.0);
	clutter_actor_set_size(keyboard_track_view, 800.0, 48.0);
	clutter_actor_set_position(drum_track_view, 194.0, 97.0);
	clutter_actor_set_size(drum_track_view, 800.0, 48.0);
	clutter_actor_set_position(slider_track_view, 194.0, 146.0);
	clutter_actor_set_size(slider_track_view, 800.0, 48.0);
	clutter_actor_set_position(audio_track_view, 194.0, 195.0);
	clutter_actor_set_size(audio_track_view, 800.0, 48.0);
	clutter_actor_set_position(loop_track_view, 194.0, 244.0);
	clutter_actor_set_size(loop_track_view, 800.0, 48.0);
	clutter_actor_set_position(backing_track_view, 194.0, 293.0);
	clutter_actor_set_size(backing_track_view, 800.0, 48.0);

	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_view), keyboard_track_view);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_view), drum_track_view);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_view), slider_track_view);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_view), audio_track_view);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_view), loop_track_view);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_view), backing_track_view);

	//Sequencer view - buttons
	ClutterActor *sequencer_button_play = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_play");
	ClutterActor *sequencer_button_play_stop = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_play_stop");
	ClutterActor *sequencer_button_home = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_home");
	ClutterActor *sequencer_button_workshop = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_workshop");
	ClutterActor *sequencer_button_mentor = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mentor");
	ClutterActor *sequencer_button_audio_record = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_audio_record");
	ClutterActor *sequencer_button_metronome = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_metronome");
	ClutterActor *sequencer_button_audio_record_stop = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_audio_record_stop");
	ClutterActor *sequencer_button_metronome_stop = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_metronome_stop");
	TEXTURE_VOLUME_BACKGROUND = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "volume_background");
	BUTTON_VOLUME_SLIDER = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "volume_button_slider");



	//ClutterActor* testinappula = jammo_sample_button_new_from_files("button_community.png",NULL);

	//ClutterActor *se = clutter_container_find_child_by_name(
	//			CLUTTER_CONTAINER(sequencer_view), "volname");

//	tangleTesti = clutter_text_new_with_text ("Sans 32px", "Hello, world");
//	clutter_container_add_actor (CLUTTER_CONTAINER (sequencer_view), tangleTesti);


	//Mute buttons
	BUTTON_SEQUENCER_MUTE[0] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_1");
	BUTTON_SEQUENCER_MUTE[1] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_2");
	BUTTON_SEQUENCER_MUTE[2] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_3");
	BUTTON_SEQUENCER_MUTE[3] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_4");
	BUTTON_SEQUENCER_MUTE[4] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_5");
	BUTTON_SEQUENCER_MUTE[5] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_mute_6");

	//Volume buttons
	BUTTON_SEQUENCER_VOLUME[0] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_1");
	BUTTON_SEQUENCER_VOLUME[1] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_2");
	BUTTON_SEQUENCER_VOLUME[2] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_3");
	BUTTON_SEQUENCER_VOLUME[3] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_4");
	BUTTON_SEQUENCER_VOLUME[4] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_5");
	BUTTON_SEQUENCER_VOLUME[5] = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(sequencer_view), "sequencer_button_volume_6");

	//Sequencer view buttons - function bindings
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_play), "button_press_event", G_CALLBACK(pressed_sequencer_button_play), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_play_stop), "button_press_event", G_CALLBACK(pressed_sequencer_button_play_stop), NULL);
	clutter_actor_hide (sequencer_button_play_stop);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_home), "button_press_event", G_CALLBACK(pressed_sequencer_button_home), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_workshop), "button_press_event", G_CALLBACK(pressed_sequencer_button_workshop), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_mentor), "button_press_event", G_CALLBACK(pressed_sequencer_button_mentor), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_audio_record), "button_press_event", G_CALLBACK(pressed_sequencer_button_audio_record), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_metronome), "button_press_event", G_CALLBACK(pressed_sequencer_button_metronome), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_audio_record_stop), "button_press_event", G_CALLBACK(pressed_sequencer_button_audio_record_stop), NULL);
	clutter_actor_hide (sequencer_button_audio_record_stop);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_metronome_stop), "button_press_event", G_CALLBACK(pressed_sequencer_button_metronome_stop), NULL);
	clutter_actor_hide (sequencer_button_metronome_stop);


	int i;

	for (i=0; i<6; i++) {
		g_signal_connect(CLUTTER_ACTOR(BUTTON_SEQUENCER_MUTE[i]), "button_press_event", G_CALLBACK(pressed_sequencer_button_mute), i);
		g_signal_connect(CLUTTER_ACTOR(BUTTON_SEQUENCER_VOLUME[i]), "button_press_event", G_CALLBACK(pressed_sequencer_button_volume), i);
	}




	g_signal_connect (TEXTURE_VOLUME_BACKGROUND, "button-press-event", G_CALLBACK (pressed_sequencer_volume_background), NULL);
	g_signal_connect (TEXTURE_VOLUME_BACKGROUND, "button-release-event", G_CALLBACK (released_sequencer_volume_background), NULL);
	g_signal_connect (TEXTURE_VOLUME_BACKGROUND, "motion-event", G_CALLBACK (motion_sequencer_volume_background), NULL);

	g_signal_connect (BUTTON_VOLUME_SLIDER, "button-press-event", G_CALLBACK (pressed_sequencer_button_volume_slider), NULL);
	g_signal_connect (BUTTON_VOLUME_SLIDER, "button-release-event", G_CALLBACK (released_sequencer_button_volume_slider), NULL);
	g_signal_connect (BUTTON_VOLUME_SLIDER, "motion-event", G_CALLBACK (motion_sequencer_button_volume_slider), NULL);

	BUTTON_SEQUENCER_PLAY = sequencer_button_play;
	BUTTON_SEQUENCER_PLAY_STOP = sequencer_button_play_stop;
	BUTTON_SEQUENCER_HOME = sequencer_button_home;
	BUTTON_SEQUENCER_WORKSHOP = sequencer_button_workshop;
	BUTTON_SEQUENCER_MENTOR = sequencer_button_mentor;
	BUTTON_SEQUENCER_AUDIO_RECORD = sequencer_button_audio_record;
	BUTTON_SEQUENCER_METRONOME = sequencer_button_metronome;
	BUTTON_SEQUENCER_AUDIO_RECORD_STOP = sequencer_button_audio_record_stop;
	BUTTON_SEQUENCER_METRONOME_STOP = sequencer_button_metronome_stop;


	//Sequencer view buttons - setting buttons reactive
	clutter_actor_set_reactive(sequencer_button_play, TRUE);
	clutter_actor_set_reactive(sequencer_button_play_stop, TRUE);
	clutter_actor_set_reactive(sequencer_button_home, TRUE);
	clutter_actor_set_reactive(sequencer_button_workshop, TRUE);
	clutter_actor_set_reactive(sequencer_button_mentor, TRUE);
	clutter_actor_set_reactive(sequencer_button_audio_record, TRUE);
	clutter_actor_set_reactive(sequencer_button_metronome, TRUE);
	clutter_actor_set_reactive(sequencer_button_audio_record_stop, TRUE);
	clutter_actor_set_reactive(sequencer_button_metronome_stop, TRUE);
	for (i=0; i<6; i++) clutter_actor_set_reactive(BUTTON_SEQUENCER_MUTE[i], TRUE);
	for (i=0; i<6; i++) clutter_actor_set_reactive(BUTTON_SEQUENCER_VOLUME[i], TRUE);

	clutter_actor_set_reactive(TEXTURE_VOLUME_BACKGROUND, TRUE);
	clutter_actor_set_reactive(BUTTON_VOLUME_SLIDER, TRUE);

	clutter_actor_hide (TEXTURE_VOLUME_BACKGROUND);
	clutter_actor_hide (BUTTON_VOLUME_SLIDER);

	return sequencer_view;

}
