/** chum.c is part of JamMo.
License: GPLv2, read more from COPYING

(from D2.4)
"CHUM controls the user interface and will communicate with all other modules. 
It will use MEAM to create music. It will use GEMS to identify and authorize
the user and to send data to other users and teacher's server. It also sends
all the user actions to CEM fo logging/mentor input/game input."
*/

#include <fcntl.h> //we check some files
#include <string.h> //we use strcmp
#include <pthread.h> // we use threads when debugging
#include <unistd.h>

#include "gui.h"
#include "chum.h"


#include "../cem/cem.h"
#include "../meam/jammo-meam.h"
#include "../meam/jammo-sample.h"
#include "../meam/jammo-editing-track.h"
#include "../meam/jammo-recording-track.h"
#include "../meam/jammo-instrument-track.h"
#include "../meam/jammo-slider-track.h"
#include "../meam/jammo-playing-track.h"

#include "../gems/gems.h"
#include <tangle.h>

/*Chum is like state-machine*/
int state_of_chum=SCREEN_WELCOME;
char* current_song;  /*for karaoke game*/

//This is not same than language from profile (which affects speech of mentor)
//This is only when user wants sing a song in different language.
const char* selected_language="_fi";

const char* chum_get_selected_language(){
	return selected_language;
}

void  chum_set_selected_language(const gchar* language){
	selected_language=language;
}


static gboolean duetto=TRUE;
void chum_set_duetto(gboolean b){
	duetto=b;
}

gboolean chum_get_duetto(){
	return duetto;
}


//FALSE means advanced_game
static gboolean chum_easy_game = TRUE;
gboolean chum_is_easy_game(){
  return chum_easy_game;
}

void chum_set_easy_game(gboolean b){
	printf("Game level set to %s\n", b ? "easy":"advanced");
	chum_easy_game=b;
}
//This helps logging/debugging state switching
char *name_of_states[] ={ "SCREEN_WELCOME",
                          "SCREEN_PASSWORD_TYPING",
                          "SCREEN_GAME_SELECTION",
                          "SCREEN_THEME_SELECTION",
                          "SCREEN_COMPOSING",
                          "SCREEN_SONG_SELECTION",
                          "SCREEN_SONG_RECORDING",
                          "SCREEN_PLAY_RECORDED",
                          "SCREEN_MIDI_EDITOR",
                          "SCREEN_SEQUENCER",
                          "SCREEN_STARTMENU",
                          "SCREEN_GAMESMENU",
                          "SCREEN_COMMUNITYMENU",
                          "SCREEN_FROM_CUPBOARD"};


gboolean multiplaying=FALSE; 
gint number_of_themes = 0;
gint chum_get_number_of_themes(){
return number_of_themes;
}

int chum_get_state_of_chum(){
return state_of_chum;
}

void chum_set_state_of_chum(int state){
state_of_chum=state;
}






const char* chum_get_current_song(){
	gchar* s;
	
	s = g_strdup_printf("get_current_song(). will return '%s'", current_song);
	cem_add_to_log(s, LOG_DEBUG);
	g_free(s);

	return current_song;
}

void chum_set_current_song(const gchar* song){
	gchar* s;
	
	s = g_strdup_printf("set_current_song(%s)", song);
	cem_add_to_log(s, LOG_DEBUG);
	g_free(s);

	g_free(current_song);
	current_song = g_strdup(song);
}


//for communication interface
JammoSample* chum_add_new_sample_to_track_remote(int a, const gchar* id, guint64 startTime){
return NULL;
}

void chum_remove_sample_from_slot_remote(int a, int slot){
return;
}


/*
We often want call:
clutter_container_foreach(CLUTTER_CONTAINER(mainview), tangle_actor_hide_animated, NULL);
But tangle_actor_hide_animated is not 'ClutterCallback'
*/
void chum_hide_this_tangle_actor (ClutterActor *actor, gpointer none){
tangle_actor_hide_animated(TANGLE_ACTOR(actor));
}
