/*
 * jammo-mentor-action.h
 *
 * This file is part of JamMo.
 *
 * (c) 2010 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

#ifndef __JAMMO_MENTOR_ACTION_H__
#define __JAMMO_MENTOR_ACTION_H__

#include <tangle.h>
#include "jammo-mentor.h"

#define JAMMO_TYPE_MENTOR_ACTION (jammo_mentor_action_get_type())
#define JAMMO_MENTOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), JAMMO_TYPE_MENTOR_ACTION, JammoMentorAction))
#define JAMMO_IS_MENTOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), JAMMO_TYPE_MENTOR_ACTION))
#define JAMMO_MENTOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), JAMMO_TYPE_MENTOR_ACTION, JammoMentorActionClass))
#define JAMMO_IS_MENTOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), JAMMO_TYPE_MENTOR_ACTION))
#define JAMMO_MENTOR_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), JAMMO_TYPE_MENTOR_ACTION, JammoMentorActionClass))

typedef struct _JammoMentorActionPrivate JammoMentorActionPrivate;

typedef struct _JammoMentorAction {
	TangleAction parent_instance;
	JammoMentorActionPrivate* priv;
} JammoMentorAction;

typedef struct _JammoMentorActionClass {
	TangleActionClass parent_class;
	
	void (*spoken)(JammoMentorAction* action, const gchar* speech);
} JammoMentorActionClass;

GType jammo_mentor_action_get_type(void) G_GNUC_CONST;

TangleAction* jammo_mentor_action_new(void);

JammoMentor* jammo_mentor_action_get_mentor(JammoMentorAction* action);
void jammo_mentor_action_set_mentor(JammoMentorAction* action, JammoMentor* mentor);
const gchar* jammo_mentor_action_get_speech(JammoMentorAction* action);
void jammo_mentor_action_set_speech(JammoMentorAction* action, const gchar* speech);
gboolean jammo_mentor_action_get_speak_once(JammoMentorAction* action);
void jammo_mentor_action_set_speak_once(JammoMentorAction* action, gboolean once);
const gchar* jammo_mentor_action_get_idle_speech(JammoMentorAction* action);
void jammo_mentor_action_set_idle_speech(JammoMentorAction* action, const gchar* speech);

#endif
