#ifndef __PM_STORAGEAGENT_H_
#define __PM_STORAGEAGENT_H_

#define JAMMOPROFILE ".jammo-profiles/"
#define PROFILETYPE ".csv"

// Profile parameters
#define PROF_PARAM_USERID "userID"
#define PROF_PARAM_USERNAME "username"
#define PROF_PARAM_AUTHLEVEL "authLevel"
#define PROF_PARAM_FIRSTNAME "firstName"
#define PROF_PARAM_LASTNAME "lastName"
#define PROF_PARAM_POINTS "gamePoints"
#define PROF_PARAM_AGE "age"

#ifdef __cplusplus

#include <map>
#include <iostream>
#include <vector>
#include <iterator>

using namespace std;

class StorageAgent 
{
public:
	// Constructor
	StorageAgent();
	// Destructor
	~StorageAgent();
	
	// Functions
	// Synchronize the data
	bool Synchronize();	
	
	// Retrieves the user data from the database
	// currently just creates static data
	bool Retrieve(int userID); 
	
	// Stores the user profile data to database
	bool Store(int userID);
	
	// Gets the details 
	string getDetails();
	
	// Gets one detail
	string getDetail(string& detail);
	
	// Set a detail
	bool setDetails(string& detail, string& newvalue);
	
	// Clear all the user details
	bool clearDetails();
	
private:
	// The map is for storing key-value pairs of user
	// profile info and an iterator for going through the data
	map<string, string> profileDetails;
	map<string, string>::const_iterator profileIterator;
	
	// This function removes the unneccesary symbols
	// From the lines read
	void Tokenize(const string& str,
			  vector<string>& tokens,
			  const string& delimiters);
};

#endif //__cplusplus

#endif /*__PM_STORAGEAGENT_H_*/

