/**json_helper.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui and it parses json config files.
*/

//This is because of getline
#define _GNU_SOURCE

#include <string.h>
#include <stdlib.h>
#include <glib-object.h>

#include "../chum/chum.h" //THEMES_DIR
/*
This function generate config.json which config.c can read.
This reads from jammo/behaviours.json and /jammo/themes/$/objects.json

objects.json isn't valid json, it hasn't parenthesis
and each object is separated with empty rows.


problems: 
if there aren't any objects in theme.
if object doesn't have text 'behaviour-object-'
*/
void generate_json_for_theme(const gchar *theme_folder) {
//Because there are problems with clutter behaviours, they are temporally disabled.
int bytes_read;
  size_t nbytes = 100;
  char *my_string;
  my_string = (char *) malloc (nbytes + 1);
  int cont=1; /*this used for while-loops*/


  //Output File//
  FILE *ofp;
  gchar* dir = THEMES_DIR;

  gchar *temp_dir = g_strdup_printf("%s/%s", "/tmp/jammo", theme_folder);
  gchar *cmd = g_strdup_printf("mkdir -p %s", temp_dir);
  int error_code = system(cmd);
  if (error_code)
      printf("Error, can't call '%s'\n",cmd);

  gchar *outputFilename = g_strdup_printf("%s/config.json", temp_dir);
  ofp = fopen(outputFilename, "w");

  if (ofp == NULL) {
      fprintf(stderr, "Can't open output file %s!\n",outputFilename);
      exit(1);
  }
  /////////////

  fprintf(ofp, "[\n");  //json starts with this



  //make header for first object (suppose that there are at least one object)
  int object_counter=1;
  fprintf(ofp, "\n\n{\n");
  fprintf(ofp, "  \"id\" : \"object-%d\",\n",object_counter);
  fprintf(ofp, "  \"type\" : \"JammoTexture\",\n");
  fprintf(ofp, "  \"load-async\" : true,\n");
  object_counter++;

  //Read objects.json
  FILE *ifp;
  gchar *objects_filename = g_strdup_printf("%s/%s/objects.json", dir, theme_folder);

  ifp = fopen(objects_filename, "r");
  if (ifp == NULL) {
      fprintf(stderr, "Can't open input file '%s'\n",objects_filename);
      exit(1);
  }

 char *pch=NULL;
 
  cont=1;
  while (cont){
    bytes_read = getline (&my_string, &nbytes, ifp);
    if (bytes_read <= 0) {
          cont=0;
          continue;
    } 

  if (strcmp(my_string,"\n")==0) {

        //and add headers of the next object
        fprintf(ofp, "},\n\n");
        fprintf(ofp, "{\n");
        fprintf(ofp, "  \"id\" : \"object-%d\",\n",object_counter);
        fprintf(ofp, "  \"type\" : \"JammoTexture\",\n");
        fprintf(ofp, "  \"load-async\" : true,");
        object_counter++;
  }    

    /*if this is name of image filename, correct path with fullpath
      sound files should be only names, they are handled different way.
      char *pcha = strstr (my_string,"\"sound-file\"");
      if (pch!=NULL || pcha!=NULL){
    */
    pch=NULL;
    pch = strstr (my_string,"\"filename\"");
    if (pch!=NULL ){ 
        char *pch2  =strtok(my_string, "\"");  //this contains spaces from beginning
        char *pch2b =strtok((char *)0, "\""); //this is 'filename'
        char *pch2c =strtok((char *)0, "\""); //this is ':' (But it can be anything, we write it unmodified)
        char *pch2d =strtok((char *)0, "\""); //this is actual name of file

        //printf("%s. %s. %s. %s.\n",pch2,pch2b,pch2c,pch2d);
        gchar *my2_string = g_strdup_printf("%s\"%s\"%s \"%s/%s/%s\",\n", pch2,pch2b,pch2c,THEMES_DIR,theme_folder,pch2d);
        fprintf(ofp, "%s",my2_string);
    }

  //if this is row which defines behaviour type, let take it 
    pch = strstr (my_string,"behaviour-object-");
    if (pch==NULL){ 
      fprintf(ofp, "%s",my_string);
    }
    
}
  


//this is the end of json-files
  fprintf(ofp, "},\n\n\n]\n");


fclose(ifp);
fclose(ofp);

#ifdef THIS_WAS_WORKING_SOLUTION_BUT_BEHAVIOURS_ARE_NO_BROKEN
  int bytes_read;
  size_t nbytes = 100;
  char *my_string;
  my_string = (char *) malloc (nbytes + 1);
  int cont=1; /*this used for while-loops*/


  //Output File//
  FILE *ofp;
  gchar* dir = THEMES_DIR;

  gchar *temp_dir = g_strdup_printf("%s/%s", "/tmp/jammo", theme_folder);
  gchar *cmd = g_strdup_printf("mkdir -p %s", temp_dir);
  int error_code = system(cmd);
  if (error_code)
      printf("Error, can't call '%s'\n",cmd);

  gchar *outputFilename = g_strdup_printf("%s/config.json", temp_dir);
  ofp = fopen(outputFilename, "w");

  if (ofp == NULL) {
      fprintf(stderr, "Can't open output file %s!\n",outputFilename);
      exit(1);
  }
  /////////////

  fprintf(ofp, "[\n");  //json starts with this


  //Behaviours file: just copy it beginning of output file
  FILE *ifp_behaviours;
  ifp_behaviours = fopen(g_strdup_printf("%s/behaviours.json",DATA_DIR), "r");
  if (ifp_behaviours == NULL) {
      fprintf(stderr, "Can't open input file \n");
      exit(1);
  }

  cont=1;
  while (cont){
    bytes_read = getline (&my_string, &nbytes, ifp_behaviours);
    if (bytes_read <= 0) {
       cont=0;
    } else {
      fprintf(ofp, "%s",my_string);
    }
  }
//////////////////////////////////////////


  //make header for first object (suppose that there are at least one object)
  int object_counter=1;
  fprintf(ofp, "\n\n{\n");
  fprintf(ofp, "  \"id\" : \"object-%d\",\n",object_counter);
  fprintf(ofp, "  \"type\" : \"JammoTexture\",\n");
  fprintf(ofp, "  \"load-async\" : true,\n");
  object_counter++;

  //Read objects.json
  FILE *ifp;
  gchar *objects_filename = g_strdup_printf("%s/%s/objects.json", dir, theme_folder);

  ifp = fopen(objects_filename, "r");
  if (ifp == NULL) {
      fprintf(stderr, "Can't open input file '%s'\n",objects_filename);
      exit(1);
  }

  cont=1;
  char behaviour_type[100];
  while (cont){
    bytes_read = getline (&my_string, &nbytes, ifp);
    if (bytes_read <= 0) {
	  cont=0;
	  continue;
    } 

    //if this is row which defines behaviour type, let take it 
    char *pch=NULL;
    pch = strstr (my_string,"behaviour-object-");
    if (pch!=NULL){ 
	strncpy(behaviour_type,pch,strlen(pch)-4);
	behaviour_type[strlen(pch)-4]='\0';
	//printf("word is '%s'\n",behaviour_type);
    }

    //if this is empty row, we know this object is ready
    if (strcmp(my_string,"\n")==0) {
	//add footers to it
	fprintf(ofp, "  \"signals\": [\n");
	fprintf(ofp, "      {\n");
	fprintf(ofp, "        \"name\": \"show\",\n");
	fprintf(ofp, "        \"handler\": \"stage_start_behaviour\",\n");
	fprintf(ofp, "        \"object\":  \"%s\",\n",behaviour_type);
	fprintf(ofp, "      }\n");
	fprintf(ofp, "    ]\n");

	//and add headers of the next object
	fprintf(ofp, "},\n\n");
	fprintf(ofp, "{\n");
	fprintf(ofp, "  \"id\" : \"object-%d\",\n",object_counter);
	fprintf(ofp, "  \"type\" : \"JammoTexture\",\n");
        fprintf(ofp, "  \"load-async\" : true,");
	object_counter++;
    }

    /*if this is name of image filename, correct path with fullpath
      sound files should be only names, they are handled different way.
      char *pcha = strstr (my_string,"\"sound-file\"");
      if (pch!=NULL || pcha!=NULL){
    */
    pch=NULL;
    pch = strstr (my_string,"\"filename\"");
    if (pch!=NULL ){ 
        char *pch2  =strtok(my_string, "\"");  //this contains spaces from beginning
        char *pch2b =strtok((char *)0, "\""); //this is 'filename'
        char *pch2c =strtok((char *)0, "\""); //this is ':' (But it can be anything, we write it unmodified)
        char *pch2d =strtok((char *)0, "\""); //this is actual name of file

        //printf("%s. %s. %s. %s.\n",pch2,pch2b,pch2c,pch2d);
        gchar *my2_string = g_strdup_printf("%s\"%s\"%s \"%s/%s/%s\",\n", pch2,pch2b,pch2c,THEMES_DIR,theme_folder,pch2d);
        fprintf(ofp, "%s",my2_string);
    }

    //write reader row to output file.
    fprintf(ofp, "%s",my_string);
  }

//and footers for last object
  fprintf(ofp, "  \"signals\": [\n");
  fprintf(ofp, "      {\n");
  fprintf(ofp, "        \"name\": \"show\",\n");
  fprintf(ofp, "        \"handler\": \"stage_start_behaviour\",\n");
  fprintf(ofp, "        \"object\":  \"%s\",\n",behaviour_type);
  fprintf(ofp, "      }\n");
  fprintf(ofp, "    ]\n");

//this is the end of json-files
  fprintf(ofp, "},\n\n\n]\n");


fclose(ifp);
fclose(ifp_behaviours);
fclose(ofp);
#endif
}
