
#include <meam/jammo-meam.h>
#include <meam/jammo-sequencer.h>
#include <meam/jammo-editing-track.h>
#include <meam/jammo-recording-track.h>
#include <meam/jammo-sample.h>

/* 
   install jammo-data. 
     backing_track is: /opt/jammo/themes/rock_city/backing_track.wav

    recording is saved into /tmp/recording.wav
     or (N900) /home/user/.jammo/recording.wav

To run: ./test-recording
*/

//N900 has very limited /tmp space.
#ifdef N900
#define RECORDING_FILENAME "/home/user/.jammo/recording.wav"
#else
#define RECORDING_FILENAME "/tmp/recording.wav"
#endif

static void on_sample_stopped(JammoSample* sample, gpointer user_data) {
	GMainLoop* main_loop;
	
	main_loop = (GMainLoop*)user_data;
	g_main_loop_quit(main_loop);
}

static void on_sequencer_stopped(JammoSequencer* sequencer, gpointer user_data) {
	JammoSample* sample;
	
	g_print("Playing...\n");
	sample = jammo_sample_new_from_file(RECORDING_FILENAME);
	g_signal_connect(sample, "stopped", G_CALLBACK(on_sample_stopped), user_data);
	jammo_sample_play(sample);
}

static void on_pitch_detected(JammoTrack* track, gfloat frequency, gpointer user_data) {
	g_print("Frequency: %f\n", frequency);
}

int main(int argc, char** argv) {
	GMainLoop* main_loop;
	JammoSequencer* sequencer;
	JammoEditingTrack* track1;
	JammoRecordingTrack* track3;
	JammoSample* sample1;

	
	jammo_meam_init(&argc, &argv);
	main_loop = g_main_loop_new (NULL, FALSE);

	sequencer = jammo_sequencer_new();
	g_signal_connect(sequencer, "stopped", G_CALLBACK(on_sequencer_stopped), main_loop);

	track1 = jammo_editing_track_new();
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(track1));
	
	sample1 = jammo_sample_new_from_file("/opt/jammo/themes/rock_city/backing_track.wav");
	jammo_editing_track_add_sample(track1, sample1, 0);


	track3 = jammo_recording_track_new_with_pitch_detect(RECORDING_FILENAME);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(track3));
	g_signal_connect(track3, "pitch-detected", G_CALLBACK(on_pitch_detected), NULL);
	g_print("Recording...\n");

	jammo_sequencer_play((JammoSequencer*)sequencer);

	g_main_loop_run(main_loop);

	return 0;
}
