/** preloader.h is part of JamMo.
License: GPLv2, read more from COPYING

This will preload graphics.
*/

#include <stdio.h>
#include <stdlib.h>
#include <gmodule.h>
#include <clutter/clutter.h>


#include <pthread.h>
#include "welcome_demo.h"
#include "main_menu.h"
//Games
#include "composing_game.h"
#include "singing_game.h"
//#include "instrument_testing.h" //For testing virtual instruments (and slider)
#include "midi_editor.h"
#include "sequencer.h"

#include "../chum/gui.h"
//Globals

//Someone asked this should be loaded next.
//-1 means there are no asked, or loading asked is ready
int asked;


static gboolean is_this_initialized(int stage) {
  switch(stage) {
    case SCREEN_WELCOME: return TRUE; break;//Welcome demo is not handled via preloader
    case SCREEN_GAME_SELECTION: return main_menu_is_initialized(); break;
    case SCREEN_THEME_SELECTION: return composing_game_is_menu_initialized(); break;
    case SCREEN_COMPOSING: return composing_game_is_game_initialized(); break;
    case SCREEN_SONG_SELECTION: return singing_game_is_initialized(); break;
    case SCREEN_SONG_RECORDING: ; break;
    case SCREEN_PLAY_RECORDED: ; break;
    case SCREEN_SEQUENCER: return sequencer_is_initialized(); break;
    case SCREEN_MIDI_EDITOR: ; break;
    default: break; // error, maybe do something?
  }
 return TRUE;
}


static void init_this(int stage){
  printf("starting init_this %d\n",stage);
  //main_menu_init();
    switch(stage) {
    case SCREEN_WELCOME: return; break;//This is welcome demo, do not preload it.
    case SCREEN_GAME_SELECTION: main_menu_init(); break;
    case SCREEN_THEME_SELECTION: composing_game_init_theme_selection(); break;
    case SCREEN_COMPOSING: composing_game_init_games(); break;
    case SCREEN_SONG_SELECTION: init_singing_game(); break;
    case SCREEN_SONG_RECORDING: ; break;
    case SCREEN_PLAY_RECORDED: ; break;
    case SCREEN_SEQUENCER: ; init_sequencer(); break;
    case SCREEN_MIDI_EDITOR: ; break;
    default: break; // error, maybe unhandled enumeration?
    }
  
  printf("screen %d initialized\n",stage);
}


static void handle_this(int i){
  printf("handle_this: %d\n",i);
  //g_usleep( 2 * G_USEC_PER_SEC );
  if (asked!=-1)
    {
    printf("asked %d\n",asked);
    if (is_this_initialized(asked))
     {}
    else
      init_this(asked);
    asked=-1;
    }

  if (is_this_initialized(i))
     {}
  else
    init_this(i);

}


//This can be called outside.
//This is called only outside.
void preloader_init_this(int stage){
printf("preloader_init_this called\n");
if (is_this_initialized(stage))
  return;
printf("not yet initialized\n");

asked=stage;
printf("preloader: going to loop\n");
while ( (asked !=-1) & (!(is_this_initialized(stage))) )
{
 // & (!(is_this_initialized(stage))))

    printf("preloader: in while loop\n");
  g_usleep( 0.2 * G_USEC_PER_SEC );
  /*
   if (is_this_initialized(stage)) //backdoor
    {
        printf("break ehto\n");
      break;
    }
    */
  }
printf("preloader: loop ready\n");
}



//ClutterActor *stage;

static void *start_preloader() {
   g_usleep( 1 * G_USEC_PER_SEC );
  int i;
  for (i=0; i<NUMBER_OF_SCREENS;i++) {
    handle_this(i);
  }

  printf("preloader ready\n");
  pthread_exit(NULL);
}




void preloader_start () {
   /* //If we want add some loading icon.
   ClutterActor *stage = main_getStage();
   ClutterActor  *actor;
   actor =clutter_rectangle_new();
   clutter_actor_set_size (actor, 400, 400);
   clutter_actor_set_position (actor, 40, 40);
   clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(actor),16);

   clutter_container_add_actor(CLUTTER_CONTAINER(stage), actor);
   clutter_actor_show_all(stage);
   */

   asked=-1;
   pthread_t preloader_thread;
   pthread_create(&preloader_thread, NULL, start_preloader, NULL);
}
