/**midi_editor.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the midi editor.
*/

#include <glib-object.h>
#include <clutter/clutter.h>
#include "midi_editor.h"


#include "jammo-texture.h"
#include "clutter_jammo.h"
//#include "object.h"

//#include "button.h"


#include "config.h"

// >> dragging grid attributes

gboolean grid_is_dragging;
gfloat x_mouse_position_f, y_mouse_position_f;
gint x_start_of_dragging, y_start_of_dragging, x_drag_offset, y_drag_offset;

// >> dragging note attributes

gboolean note_is_dragging;
gfloat x_mouse_position_f_note, y_mouse_position_f_note, x_start_position_note, y_start_position_note;
gint x_start_of_dragging_note, y_start_of_dragging_note, x_drag_offset_note, y_drag_offset_note;


//Grid and note related parameters
//NOTE: NOT FINAL

const int GRID_NOTE_SIZE = 64;
const int GRID_NUMBER_OF_NOTES = 24;
const int GRID_SIZE = 24*(64);
const int GRID_STARTPOS_X = 100;
const int GRID_STARTPOS_Y = 0;
const double GRID_SCALE_OUT = 1.0;
const double GRID_SCALE_IN = 0.3;

gfloat GRID_POSITION_X, GRID_POSITION_Y;

// menu parameters

const int MENU_STARTPOS_X = 0;
const int MENU_STARTPOS_Y = 384;

// to keep track where users finger is

gfloat FINGER_POS_X;
gfloat FINGER_POS_Y;

// to keep track which note have been clicked last time.. x and y (corner..)

gfloat LAST_NOTE_X, LAST_NOTE_Y;

//Pointer to piano key group, needed for synchronization with grid_motion
ClutterActor* pianoLeft;
//Pointer to grid..
ClutterActor* grid;
//Pointer to bottom menu
ClutterActor* menuBottom;
//Pointer to trash button
ClutterActor* button_trash;
//Pointer to note ( we need this to select note )
ClutterActor* tempNotePointer;


/*
 * cursorType attribute holds value which tells us, what kind of button we have selected and what actions we can do with it?
 *
 * Example: 0 - Normal cursor
 * 			1 - Pencil cursor
 * 			2 - etc..
 */

gint cursorType=0;

// not sure if we need these.. but maybe if we add some more functionality!
void setCursorType(gint i){
	cursorType=i;
}

gint getCursorType(){
	return cursorType;
}


//Scales the grid and piano roll to emulate zoom
void zoom_pressed(ClutterActor *zoom_button, ClutterEvent *event, gpointer data){

	gdouble scale_x, scale_y;
	clutter_actor_get_scale(grid, &scale_x, &scale_y);

		if (scale_x!=GRID_SCALE_IN) 	// zooming in
		{
		clutter_actor_set_scale(grid, GRID_SCALE_IN, GRID_SCALE_IN);
		clutter_actor_set_scale(pianoLeft, GRID_SCALE_OUT, GRID_SCALE_IN);
		}
		else // zooming out
		{
		clutter_actor_set_scale(grid, GRID_SCALE_OUT, GRID_SCALE_OUT);
		clutter_actor_set_scale(pianoLeft, GRID_SCALE_OUT, GRID_SCALE_OUT);
		}

}

//Returns the view to the start of the grid
void finder_pressed(ClutterActor *finder, ClutterEvent *event, gpointer data) {

	clutter_actor_set_position (grid, GRID_STARTPOS_X, GRID_STARTPOS_Y);
	clutter_actor_set_position (pianoLeft, 0, 0);

}

/*
 * This function calls pencil, and we allow user to make new notes.
 */

void pencil_pressed(ClutterActor *finder, ClutterEvent *event, gpointer data) {

printf("\n PENCIL CALLED!!!");

if (getCursorType())
setCursorType(0);

else
setCursorType(1);

}

/*
 * This function snaps note to grid
 */

void snapNoteToGrid(gint *snapX, gint *snapY) {

	gfloat calculateHelperX, calculateHelperY;

	GRID_POSITION_X = clutter_actor_get_x(CLUTTER_ACTOR(grid));
	GRID_POSITION_Y = clutter_actor_get_y(CLUTTER_ACTOR(grid));

	//printf("\n\nGRID_POSITION: x %f ja y %f", GRID_POSITION_X,GRID_POSITION_Y);
	//printf("\n\nFINGER_POSITION: x %f ja y %f", FINGER_POS_X,FINGER_POS_Y);

	calculateHelperX = (FINGER_POS_X-GRID_POSITION_X)/GRID_NOTE_SIZE;
	calculateHelperY = (FINGER_POS_Y-GRID_POSITION_Y)/GRID_NOTE_SIZE;

	//printf("\n\nCALCULATE_HELPER: x %f ja y %f", calculateHelperX,calculateHelperY);

	gint xCoord, yCoord;

	xCoord = (gint)calculateHelperX;
	yCoord = (gint)calculateHelperY;

	//printf("\n\nCOORD 1: x %d ja y %d", xCoord,yCoord);

	 xCoord = xCoord * GRID_NOTE_SIZE;
	 yCoord = yCoord * GRID_NOTE_SIZE;

	//printf("\n\nCOORD 2: x %d ja y %d", xCoord,yCoord);

	 *snapX = xCoord;
	 *snapY = yCoord;

}

/*
 * This functions makes sure that we always save last spot where we have been clicked
 */

void setFingerPos(ClutterEvent *event) {
clutter_event_get_coords (event, &FINGER_POS_X, &FINGER_POS_Y);
}

/*
 * This function will create note and snap it to grid
 */

void createNote(void) {

	// setFingerPos(event);

	 ClutterActor* note = clutter_rectangle_new_with_color(get_blue_color());
	 clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(note),get_white_color());
	 clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(note), 2);
	 clutter_actor_set_size(note, GRID_NOTE_SIZE, GRID_NOTE_SIZE);

	 gint finalNotePosX, finalNotePosY;
	 snapNoteToGrid(&finalNotePosX, &finalNotePosY);

	 clutter_actor_set_position(CLUTTER_ACTOR(note), finalNotePosX, finalNotePosY);
	 clutter_actor_show(note);
	 clutter_container_add_actor(CLUTTER_CONTAINER(grid), note);
	 clutter_actor_set_reactive(note, TRUE);

	 g_signal_connect (note, "button-press-event", G_CALLBACK (note_pressed),NULL);
	 g_signal_connect (note, "button-release-event", G_CALLBACK (note_released),NULL);
	 g_signal_connect (note, "motion-event", G_CALLBACK (note_motion), NULL);

}


/*
 * This function deletes note, it is called when note is dragged to trash
 */

void deleteNote(ClutterActor *actor) {

	clutter_actor_destroy (actor);
	printf("\nnote deleted");

}


void note_pressed(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	clutter_actor_get_position(actor, &LAST_NOTE_X, &LAST_NOTE_Y);
	clutter_event_get_coords (event, &x_start_position_note, &y_start_position_note);

		if (clutter_actor_get_opacity(actor)==128){

		gfloat x_start_of_dragging_f_note,y_start_of_dragging_f_note;
	    clutter_event_get_coords (event, &x_start_of_dragging_f_note, &y_start_of_dragging_f_note);

	    x_start_of_dragging_note=(gint)x_start_of_dragging_f_note;
	    y_start_of_dragging_note=(gint)y_start_of_dragging_f_note;

	    note_is_dragging=TRUE;
	    grid_is_dragging=FALSE;

	    x_drag_offset_note = (clutter_actor_get_x (CLUTTER_ACTOR(actor)) - (int)x_start_of_dragging_note);
	    y_drag_offset_note = (clutter_actor_get_y (CLUTTER_ACTOR(actor)) - (int)y_start_of_dragging_note);

	    //even this object is not focused it still gets the mouse events
	    clutter_grab_pointer(CLUTTER_ACTOR(actor));

		} else {

			clutter_event_get_coords (event,&x_start_position_note, &y_start_position_note);
			tempNotePointer = actor;
			grid_is_dragging=TRUE;

			clutter_grab_pointer(CLUTTER_ACTOR(grid));

		}
}

void note_motion(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	 if (CLUTTER_IS_ACTOR(actor) && note_is_dragging) {
	      //printf("drag\n");
	      clutter_event_get_coords (event,&x_mouse_position_f_note, &y_mouse_position_f_note);
	      //printf("X=%f, Y=%f\n",x_mouse_position, y_mouse_position);
	      gint new_x_note, new_y_note;
	      gint x_mouse_position_note=(gint)x_mouse_position_f_note;
	      gint y_mouse_position_note=(gint)y_mouse_position_f_note;

	      new_x_note=x_mouse_position_note + x_drag_offset_note;
	      new_y_note=y_mouse_position_note + y_drag_offset_note;

	      clutter_actor_set_position (CLUTTER_ACTOR(actor), new_x_note, new_y_note);
	  }

}


void note_released(ClutterActor *actor, ClutterEvent *event, gpointer data) {

	setFingerPos(event);

	gfloat trash_x, trash_y;

	// TODO: make here "function" which takes note from this position where we are dragging the another note..
	// we need this to make sure that we wont stack notes!

	clutter_actor_get_position(button_trash, &trash_x, &trash_y );

	gfloat trash_right_x = trash_x + clutter_actor_get_width(button_trash);
	gfloat trash_top_y = trash_y + clutter_actor_get_height(button_trash);

	if (note_is_dragging) {
		clutter_actor_set_opacity(actor,255);

		if( FINGER_POS_X >= trash_x && FINGER_POS_X <= trash_right_x && (480-FINGER_POS_Y) >= trash_y && (480-FINGER_POS_Y) <= trash_top_y ){
			deleteNote(actor);
		}
		// if the place is on the piano or black area >>> TODO : OR there is another note at the same position.. swap note back to start position
		else if (FINGER_POS_X <= GRID_STARTPOS_X || FINGER_POS_Y >= MENU_STARTPOS_Y)
		{
			clutter_actor_set_position (CLUTTER_ACTOR(actor), LAST_NOTE_X, LAST_NOTE_Y);
		}
		else
		{

			 gint finalNotePosX, finalNotePosY;
			 snapNoteToGrid(&finalNotePosX, &finalNotePosY);

			 clutter_actor_set_position(CLUTTER_ACTOR(actor), finalNotePosX, finalNotePosY);
		}
	}

	tempNotePointer = NULL;
	clutter_ungrab_pointer(); //ungrab
	note_is_dragging = FALSE;
	grid_is_dragging = FALSE;

}

void grid_motion(ClutterActor *actor, ClutterEvent *event, gpointer data) {

  if (CLUTTER_IS_ACTOR(actor) && grid_is_dragging) {
	 // clutter_event_get_coords (event, &FINGER_POS_X, &FINGER_POS_Y);
      //printf("drag\n");
      clutter_event_get_coords (event,&x_mouse_position_f, &y_mouse_position_f);
      //printf("X=%f, Y=%f\n",x_mouse_position, y_mouse_position);
      gint new_x, new_y;
      gint x_mouse_position=(gint)x_mouse_position_f;
      gint y_mouse_position=(gint)y_mouse_position_f;

      new_x=x_mouse_position + x_drag_offset;
      new_y=y_mouse_position + y_drag_offset;

      //Debug print for snaps
      //gfloat gridPosY = clutter_actor_get_y(actor);
      //printf("%f\n", gridPosY);

      //Preliminary grid boundary point calculation
      //NOTE: WILL CHANGE AFTER FINAL NOTE SIZE SPECS
      int lowest_point_y = -GRID_SIZE+(7*GRID_NOTE_SIZE);
      int highest_point_y = 0;
      gfloat piano_x = clutter_actor_get_x(pianoLeft);

      //Restrict grid movement on the y-axis by setting up bottom and top limiters
      if(new_y >= lowest_point_y && new_y <= highest_point_y) {
    	  clutter_actor_set_position (CLUTTER_ACTOR(actor), new_x, new_y);
    	  clutter_actor_set_position (CLUTTER_ACTOR(pianoLeft), piano_x, new_y);
      }
      //If past the highest point (the top of the grid)
      else if(new_y >= highest_point_y) {
    	  clutter_actor_set_position(CLUTTER_ACTOR(actor), new_x, highest_point_y);
    	  clutter_actor_set_position(CLUTTER_ACTOR(pianoLeft), piano_x, highest_point_y);
      }
      //If past the lowest point (the bottom of the grid)
      else {
    	  clutter_actor_set_position (CLUTTER_ACTOR(actor), new_x, lowest_point_y);
    	  clutter_actor_set_position (CLUTTER_ACTOR(pianoLeft), piano_x, lowest_point_y);
      }

      //Restrict grid's left to right movement from moving past the piano
      //Restrict X if past piano and Y past the highest point
      if(new_x >= 100 && new_y >= highest_point_y ) {
    	  clutter_actor_set_position(CLUTTER_ACTOR(actor), 100, highest_point_y);
      }
      //Restrict X if past piano
      else if(new_x >= 100 && new_y >= lowest_point_y && new_y <= highest_point_y){
    	  clutter_actor_set_position(CLUTTER_ACTOR(actor), 100, new_y);
      }
      //Restrict X if past piano and Y past the lowest point
      else if(new_x >= 100 && new_y <= lowest_point_y ){
    	  clutter_actor_set_position(CLUTTER_ACTOR(actor), 100, lowest_point_y);
      }
  }
}


void grid_pressed (ClutterActor *actor, ClutterEvent *event, gpointer data) {

	setFingerPos(event);

   if (getCursorType()) {
	  createNote();
  }

else {


  gfloat x_start_of_dragging_f,y_start_of_dragging_f;
  clutter_event_get_coords (event, &x_start_of_dragging_f, &y_start_of_dragging_f);

  x_start_of_dragging=(gint)x_start_of_dragging_f;
  y_start_of_dragging=(gint)y_start_of_dragging_f;

  grid_is_dragging=TRUE;

  x_drag_offset = (clutter_actor_get_x (CLUTTER_ACTOR(actor)) - (int)x_start_of_dragging);
  y_drag_offset = (clutter_actor_get_y (CLUTTER_ACTOR(actor)) - (int)y_start_of_dragging);

}

}


void grid_released (ClutterActor *actor, ClutterEvent *event, gpointer data) {

	setFingerPos(event);

	// NOTE!! make here some sort of better check for finger "touching"..
	// this cant be done without nokia n900..?

	if (FINGER_POS_X==x_start_position_note && FINGER_POS_Y==y_start_position_note && tempNotePointer!=NULL){

	clutter_actor_set_opacity(tempNotePointer,128);

	//if (clutter_actor_get_opacity(actor)==128)

	}

	clutter_ungrab_pointer(); //ungrab
	tempNotePointer=NULL;
	note_is_dragging = FALSE;
	grid_is_dragging = FALSE;

}


void start_midi_editor() {
  ClutterActor* stage = main_getStage();

 // grid = config_get_configured_actor(NULL,"house"); //just some image

  //Set up a grid-style note container
  grid = clutter_group_new();
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), grid);
  clutter_actor_show (grid);
  clutter_actor_set_reactive(grid, TRUE);
  clutter_actor_set_size (grid, GRID_SIZE, GRID_SIZE);
  clutter_actor_set_position (grid, GRID_STARTPOS_X, GRID_STARTPOS_Y);

  //Background for the note screen.. makes easier to follow notes and stuff behavior..

   ClutterActor *note_background = clutter_rectangle_new_with_color(get_green_color());
   clutter_actor_set_size(note_background, 700, 384);
   clutter_actor_set_position(note_background, 100, 0);
   clutter_actor_set_opacity(note_background,128);
   clutter_actor_set_reactive(note_background, FALSE);
   clutter_actor_show(note_background);
   clutter_container_add_actor(CLUTTER_CONTAINER(stage), note_background);

  g_signal_connect (grid, "button-release-event", G_CALLBACK (grid_released), NULL);
  g_signal_connect (grid, "motion-event", G_CALLBACK (grid_motion), NULL);
  g_signal_connect (grid, "button-press-event", G_CALLBACK (grid_pressed),NULL);

  //Placeholder for piano key group
  pianoLeft=clutter_group_new();
  clutter_actor_set_size(pianoLeft,100,480);
  clutter_actor_set_position(pianoLeft,0, 0);
  clutter_actor_set_reactive(pianoLeft, TRUE);
  clutter_actor_show(pianoLeft);
  clutter_container_add_actor(CLUTTER_CONTAINER(stage), pianoLeft);

  int white_pos;
  //Lay out invidual piano keys
  for(white_pos = 0; white_pos < GRID_NUMBER_OF_NOTES; white_pos++) {
	  ClutterActor *box = clutter_rectangle_new_with_color(get_black_color());
	  clutter_actor_set_size(box, 100, GRID_NOTE_SIZE);
	  clutter_actor_set_position(box, 0, white_pos*(GRID_NOTE_SIZE));
	  clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(box),get_white_color());
	  clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(box), 2);
	  clutter_actor_show(box);
	  clutter_container_add_actor(CLUTTER_CONTAINER(pianoLeft), box);
  }

  //Menu bar group
  //NOTE: Might be a good idea to separate into it's own function
  menuBottom=clutter_group_new();
  clutter_actor_set_size(menuBottom,800,96);
  clutter_actor_set_position(menuBottom, MENU_STARTPOS_X, MENU_STARTPOS_Y);
  clutter_actor_set_reactive(menuBottom, TRUE);
  clutter_actor_show(menuBottom);
  clutter_container_add_actor(CLUTTER_CONTAINER(stage), menuBottom);

  //Background for the menu bar
  ClutterActor *menu_background = clutter_rectangle_new_with_color(get_black_color());
  clutter_actor_set_size(menu_background, 800, 96);
  clutter_actor_set_position(menu_background, 0, 0);
  clutter_actor_show(menu_background);
  clutter_container_add_actor(CLUTTER_CONTAINER(menuBottom), menu_background);

  //NOTE: textures are just placeholders
  ClutterActor *button_playstop = config_get_configured_actor(NULL, "contour_star");
  clutter_actor_set_position(button_playstop,25,20);
  clutter_actor_set_size(button_playstop, 50, 50);
  clutter_container_add_actor(CLUTTER_CONTAINER(menuBottom), button_playstop);
  clutter_actor_show(button_playstop);
  clutter_actor_set_reactive(button_playstop, TRUE);

  button_trash = config_get_configured_actor(NULL, "contour_star");
  clutter_actor_set_position(button_trash, 125, 20);
  clutter_actor_set_size(button_trash, 50, 50);
  clutter_container_add_actor(CLUTTER_CONTAINER(menuBottom), button_trash);
  clutter_actor_show(button_trash);
  clutter_actor_set_reactive(button_trash, TRUE);
  //g_signal_connect (buttonTrash, "button-press-event", G_CALLBACK (menuButton_pressed),NULL);
  //we wont need signal here, because if we want to delete something -> we drag and drop it..

  ClutterActor *button_finder = config_get_configured_actor(NULL, "contour_star");
  clutter_actor_set_position(button_finder, 225,20);
  clutter_actor_set_size(button_finder, 50, 50);
  clutter_container_add_actor(CLUTTER_CONTAINER(menuBottom), button_finder);
  clutter_actor_show(button_finder);
  clutter_actor_set_reactive(button_finder, TRUE);
  g_signal_connect (button_finder, "button-press-event", G_CALLBACK (finder_pressed),NULL);

  ClutterActor *button_pencil = config_get_configured_actor(NULL, "contour_star");
  clutter_actor_set_position(button_pencil, 325,20);
  clutter_actor_set_size(button_pencil, 50, 50);
  clutter_container_add_actor(CLUTTER_CONTAINER(menuBottom), button_pencil);
  clutter_actor_show(button_pencil);
  clutter_actor_set_reactive(button_pencil, TRUE);
  g_signal_connect (button_pencil, "button-press-event", G_CALLBACK (pencil_pressed),NULL);

  ClutterActor *button_zoom = config_get_configured_actor(NULL, "microphone");
  clutter_actor_set_position(button_zoom,425,20);
  clutter_actor_set_size(button_zoom, 50, 50);
  clutter_container_add_actor(CLUTTER_CONTAINER(menuBottom), button_zoom);
  clutter_actor_show(button_zoom);
  clutter_actor_set_reactive(button_zoom, TRUE);
  g_signal_connect (button_zoom, "button-press-event", G_CALLBACK (zoom_pressed),NULL);

}
