/**stand_alone_player.c is part of JamMo.
License: GPLv2, read more from COPYING

This is one module of MEAM. This play single files.
This does not init gst, do it before using.
This plays only one file at a time. If new file is asked to play, previous is stopped.

FIX:currently plays only wav files!
*/

#include <gst/gst.h>
#include "stand_alone_player.h"

GstElement* file_source;
GstElement* pipeline=NULL;

static gboolean on_bus_watch(GstBus* bus, GstMessage* message, gpointer data) {

  //g_print ("Got %s message\n", GST_MESSAGE_TYPE_NAME (message));

  switch (GST_MESSAGE_TYPE (message)) {
    case GST_MESSAGE_ERROR: {
      GError *err;
      gchar *debug;

      gst_message_parse_error (message, &err, &debug);
      g_print ("Error: %s\n", err->message);
      g_error_free (err);
      g_free (debug);

      break;
    }
    case GST_MESSAGE_EOS:
      /* end-of-stream */
      stand_alone_stop_one_sample();
      break;
    default:
      /* unhandled message */
      break;
  }

  return TRUE;
}

static void connect_to_element(GstElement* element, GstPad* pad, gpointer data) {
	GstElement* to_element;

	to_element = GST_ELEMENT(data);
	gst_element_link(element, to_element);
}


/* //This can't play wavs. it handles ogg/mp3
static GstElement* create_music_bin(const char* name, const char* filename) {
    GstElement *play = gst_element_factory_make ("playbin", name);
    g_object_set (G_OBJECT (play), "uri", filename, NULL);
    return play;
}
*/

/*This plays only wavs.*/
static GstElement* create_wav_bin() {

   GstElement* bin;
   GstElement* decoder;
   GstElement* converter;
   GstElement* sink;

   const char* name = "wav-player";
   bin= gst_bin_new(name);

   file_source = gst_element_factory_make("filesrc", NULL);
   converter = gst_element_factory_make("audioconvert", NULL);
   sink = gst_element_factory_make("autoaudiosink", NULL);

   decoder = gst_element_factory_make("wavparse", NULL);
   gst_bin_add_many(GST_BIN(bin), file_source, decoder, converter, sink, NULL);
   gst_element_link(file_source, decoder);
   gst_element_link_many (decoder, converter, NULL);
   g_signal_connect(decoder, "pad-added", G_CALLBACK(connect_to_element), converter);

   gst_element_link(converter, sink);

   return bin;
}


void stand_alone_stop_one_sample() {
  printf("stand_alone_stop_one_sample \n");
  gst_element_set_state(pipeline, GST_STATE_NULL);
}


void stand_alone_play_one_sample(gchar* filename) {
    printf("stand_alone_play_one_sample: file asked %s\n",filename);
    GstElement* player=NULL;
    GstBus* bus;

    //First time do initialization.
    if (pipeline==NULL) {
      pipeline = gst_pipeline_new("stand_alone_pipeline");
      player = create_wav_bin();
      gst_bin_add(GST_BIN(pipeline), player);
      bus = gst_element_get_bus(GST_ELEMENT(pipeline));
      gst_bus_add_watch(bus, on_bus_watch, NULL);
      //gst_object_unref(bus);
    }

    //If there are previous file playing, stop it.
    GstState state;
    gst_element_get_state (pipeline, &state, NULL, 0);
    if (state == GST_STATE_PLAYING){
        stand_alone_stop_one_sample();
    }

    //set played filename
    g_object_set(G_OBJECT(file_source), "location", filename, NULL);

    gst_element_set_state(pipeline, GST_STATE_PLAYING);
}

