/**sample.h is part of JamMo.
License: GPLv2, read more from COPYING
*/

#ifndef __SAMPLE_H__
#define __SAMPLE_H__

#include <gst/gst.h>
#include "track.h"
#include "duration.h"

// Struct definition
typedef struct Sample {
	struct Track *parent;
	gchar source[150];
	GstElement *audiosource;
	guint64 start_time;
	guint64 end_time;
	guint64 duration;
} Sample;



// Function prototypes
Sample *add_new_sample_to_track(int track_number, const gchar srcLocation[], guint64 startTime);
Sample *add_new_sample_to_track_nth_slot(int track_number, const gchar srcLocation[], guint slot);
void remove_sample_from_track(Sample *smp);
void empty_track_from_slot(guint track_number,int slot);

void free_sample(Sample *smp);
void set_samples_startTime(Sample *smp, guint64 startTime);


#endif /* __SAMPLE_H__ */
