/**jammo-texture.c is part of JamMo.
License: GPLv2, read more from COPYING

jammo-texture is subclass of clutter-texture.
It contains handle to sample file.
(This might be bad thing: Now jammo-texture has/must have
 straight access to ../meam/sequencer/sample)
*/

#include "jammo-texture.h"
#include "../meam/sequencer/sample.h"

G_DEFINE_TYPE(JammoTexture, jammo_texture, CLUTTER_TYPE_TEXTURE);

enum {
	PROP_0,
	PROP_SOUND_FILE_NAME,
	PROP_SAMPLE
};

struct _JammoTexturePrivate {
	gchar* sound_file_name;
	Sample *sample;
};

static void jammo_texture_set_property(GObject* object, guint prop_id, const GValue* value, GParamSpec* pspec) {
	JammoTexture* texture;
	
	texture = JAMMO_TEXTURE(object);

	switch (prop_id) {
		case PROP_SOUND_FILE_NAME:
			jammo_texture_set_sound_file_name(texture, g_value_get_string(value));
			break;
		case PROP_SAMPLE:
			//jammo_texture_set_sample(texture, value);
			break;
		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
			break;
	}
}

static void jammo_texture_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* pspec) {
        JammoTexture* texture;

	texture = JAMMO_TEXTURE(object);

        switch (prop_id) {
		case PROP_SOUND_FILE_NAME:
			g_value_set_string(value, jammo_texture_get_sound_file_name(texture));
			break;
		case PROP_SAMPLE:
			//value= jammo_texture_get_sample(texture);
			break;
	        default:
		        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		        break;
        }
}

static void jammo_texture_finalize(GObject* object) {
	G_OBJECT_CLASS (jammo_texture_parent_class)->finalize(object);
}

static void jammo_texture_dispose(GObject* object) {
	G_OBJECT_CLASS (jammo_texture_parent_class)->dispose(object);
}

static void jammo_texture_class_init(JammoTextureClass* klass) {
	GObjectClass* gobject_class = G_OBJECT_CLASS (klass);

	gobject_class->finalize     = jammo_texture_finalize;
	gobject_class->dispose      = jammo_texture_dispose;
	gobject_class->set_property = jammo_texture_set_property;
	gobject_class->get_property = jammo_texture_get_property;

	g_type_class_add_private (gobject_class, sizeof (JammoTexturePrivate));

	/**
	 * JammoTexture:sound-file:
	 */
	g_object_class_install_property(gobject_class, PROP_SOUND_FILE_NAME,
	                                g_param_spec_string("sound-file",
	                                "A filename for a sound loop.",
	                                "A filename for a sound loop played with the texture.",
	                                NULL, 
	                                G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK |G_PARAM_STATIC_BLURB));

	/**
	 * JammoTexture:sample:
	 */
	g_object_class_install_property(gobject_class, PROP_SAMPLE,
	                                g_param_spec_string("sample",
	                                "Pointer to sound loop.",
	                                "Pointer to sound loop played with the texture.",
	                                NULL, 
	                                G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK |G_PARAM_STATIC_BLURB));
}

static void jammo_texture_init (JammoTexture* texture) {
	texture->priv = G_TYPE_INSTANCE_GET_PRIVATE(texture, JAMMO_TYPE_TEXTURE, JammoTexturePrivate);
}

JammoTexture* jammo_texture_new() {
	return JAMMO_TEXTURE(g_object_new (JAMMO_TYPE_TEXTURE, NULL));
}

/**
 * Sets the value of the sound-file property.
 *
 * @param texture A Texture
 * @param sound-file a new value of the sound-file property
 */
void jammo_texture_set_sound_file_name(JammoTexture* texture, const gchar* sound_file_name) {
	g_return_if_fail(JAMMO_IS_TEXTURE(texture));

	g_free(texture->priv->sound_file_name);
	texture->priv->sound_file_name = g_strdup(sound_file_name);
}

/**
 * Returns the value of the sound-file property.
 *
 * @param texture A Texture
 * @return the current value of the sound-file property
 */
const gchar* jammo_texture_get_sound_file_name(JammoTexture* texture) {
	g_return_val_if_fail(JAMMO_IS_TEXTURE(texture), NULL);

        return texture->priv->sound_file_name;
}


/**
 * Sets the value of the sound-file property.
 *
 * @param texture A Texture
 * @param sound-file a new value of the sound-file property
 */
void jammo_texture_set_sample(JammoTexture* texture, Sample* sample) {
	g_return_if_fail(JAMMO_IS_TEXTURE(texture));
	//is this needed?
	//Sample *n_sample = (Sample*) malloc(sizeof(Sample));
	texture->priv->sample = sample;
}


/**
 * Returns the value of the sound-file property.
 *
 * @param texture A Texture
 * @return the current value of the sound-file property
 */
Sample* jammo_texture_get_sample(JammoTexture* texture) {
	g_return_val_if_fail(JAMMO_IS_TEXTURE(texture), NULL);

        return texture->priv->sample;
}
