#include "single_thread.h"
#include <stdio.h>
#include <tangle.h>
#include <stdlib.h>
#include <string.h>
#include "../jammo.h"
#include "community_utilities.h"
#include "jammosongs.h"

static ClutterContainer *messageList = 0;
GList* messages;
ClutterActor *answerField = 0;

void start_thread_view(GList* listOfMessages){

	int i = 0;
	
	messages = listOfMessages; 

	
	puts("starting thread...");


	
	ClutterActor* thread_view = jammo_get_actor_by_id("single-thread-view");

	
	if(thread_view){
	
		clutter_actor_show(thread_view);
		
		if(answerField == 0){
			answerField = jammo_get_actor_by_id("answer-field");
		}
		
		clutter_text_set_text(CLUTTER_TEXT(answerField), "");
		
		if(messages != NULL){
		
			messages = g_list_first(messages);
			
			if(g_list_length(messages) > 3)					
				messageList = CLUTTER_CONTAINER(jammo_get_actor_by_id("single-thread-list-scrollable"));
			else 
				messageList = CLUTTER_CONTAINER(jammo_get_actor_by_id("single-thread-list-unscrollable"));
				
			do{	
				if(i > 0){
					messages = messages->next;

				}
				
				add_message_to_list(messages->data);
				i++;
		
				
			}while(messages->next != NULL);
		}
		
		
		
	}
	
	
	else
		puts("can't find single-thread-view");
	

}

void add_message_to_list(gpointer data){

	static int index = 0;
	
	ClutterActor* messageBackground = 0;
	ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());
	ClutterActor* message = clutter_text_new_with_text("Times", data);
	ClutterActor* avatar = 0;
	
	avatar = clutter_texture_new_from_file("/opt/jammo/communitymenu/bear.png", NULL); //this is test avatar
	
	index = (index+1) % 3;
	
	
	switch(index){			   
		case 0: messageBackground = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar1.png", NULL);
			break;
		case 1: messageBackground = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar4.png", NULL);
			break;
		case 2: messageBackground = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar7.png", NULL);
			break;
		
	}
	
	
	
	clutter_actor_set_size(messageBackground, 800, 100);
	clutter_container_add_actor(listContainer, messageBackground);
	clutter_container_add_actor(listContainer, avatar);
	clutter_actor_set_position(message, 100, 0);
	clutter_container_add_actor(listContainer, message);
	clutter_container_add_actor(messageList, CLUTTER_ACTOR(listContainer));
	
	
	/*
	clutter_container_add_actor(messageList, messageBackground);
	clutter_container_add_actor(messageList, message);*/
		

}

void add_comment(){

	gchar *comment; 

	clear_container(messageList);
	//clutter_actor_hide(jammo_get_actor_by_id("single-thread-view"));
	comment = malloc((strlen(clutter_text_get_text(CLUTTER_TEXT(answerField)))+1) * sizeof(gchar));
	
	strcpy(comment, clutter_text_get_text(CLUTTER_TEXT(answerField)));
	messages = g_list_append(messages, (gpointer)(comment));
	start_thread_view(messages);


}

void end_single_thread(){

	messages = g_list_first(messages);

	if(messages != NULL){
		
		if(messages->data != NULL){
			free(messages->data);
			
			}
		while(messages->next != NULL){
			messages = messages->next;
			if(messages->data != NULL){
				free(messages->data);
				}		
		}	
	
	}

	clear_container(messageList);
	g_list_free(g_list_first(messages));		
	start_jammosongs();

}





