#include <tangle.h>
#include <glib-object.h>
#include <sys/time.h>
#include "community_utilities.h"
#include "../jammo.h"
#include "../../meam/jammo-sample.h"

/*
*Function computes the length of the click.
*If the length of the click is more than 1 seconds, function to rename the item is called.
*Otherwise a function to play the appropriate music piece is called. 
*/

void song_name_press_action(ClutterActor* loopName){

	static gboolean clicked = FALSE;
	static struct timeval timePressed;
	struct timeval timeReleased;

	
	clicked = !clicked;

	if(clicked){
		gettimeofday(&timePressed, NULL);
		}
	
	else{	
		gettimeofday(&timeReleased, NULL);
		
		if(timeReleased.tv_sec-timePressed.tv_sec > 1){
	
			rename_loop(loopName);	
		} 
		else if((timeReleased.tv_sec-timePressed.tv_sec == 1) && (timeReleased.tv_usec >= timePressed.tv_usec)){
			
			rename_loop(loopName);
		
		}
	
		else{
			play_selected_loop(loopName);
	
		}
	}	
	
}


void rename_loop(ClutterActor *loopName){

	//TODO: use writing tool to rename the loop

}

void play_selected_loop(ClutterActor *loopName){
	
	//TODO: add correct loop, this one is just to test the button
	static JammoSample *sample = NULL;
	
	if(sample == NULL){
		//songName = "/home/teppo/jammo10-jammo-data/data/jammo7-12_all/backingtracks/Sa_LaBamba_110_A.ogg";
		puts("Starting loop");
		sample = jammo_sample_new_from_file("/home/teppo/jammo10-jammo-data/data/jammo7-12_all/backingtracks/Sa_LaBamba_110_A.ogg");
	
		jammo_sample_play(sample);
	}
	
	else{
		puts("loop stop");
		jammo_sample_stop(sample);
		g_object_unref(sample);
		sample = NULL;
	
	}

}

void show_song_label(ClutterActor* songName){

	//TODO: show label

	puts("Showing imaginary song label");
}


void show_music_video(ClutterActor* songName){

	//TODO: play music video
	
	puts("Showing imaginary music video");

}


void clear_container(ClutterContainer *listToClear){
	
	int i = 0;
	GList *listItems;
	
	if(listToClear != NULL){
	 	
		listItems = clutter_container_get_children(listToClear);
		
		if(listItems != NULL){
		
			do{			
				if(i > 0)
					listItems = listItems->next;
								
				clutter_container_remove_actor(CLUTTER_CONTAINER(listToClear), CLUTTER_ACTOR(listItems->data));
				i++;
	
			}while(listItems->next != NULL);
		
		g_list_free(listItems);

		}

	}

}

