#include "gems_service_songbank.h"

int gems_service_songbank_init(gems_components* data, char* _baseDirectory){

	sb = data->service_songbank;

	sb = malloc( sizeof(gems_service_songbank) );
	
	sb->baseDirectory = _baseDirectory;

	if( data == NULL || data->ph == NULL ) 
		return FALSE; // no PeerHood = no network

	if( SongBankComm_init( sb->sbComm, data->ph ) == TRUE ){
		printf("SBComm start SUCCESS");
		return TRUE;
	}
	else{
		printf("SBComm start FAILURE");
		free(sb->sbComm);
		sb->sbComm = NULL;
		return FALSE;
	}
}

void gems_service_songbank_clean(){

//	free(sb->baseDirectory);
	SongBankComm_clean();
	free(sb);
}

char* GetAuthorNameXML( char* filepath ){

	char* authorName = NULL;
	xmlDocPtr doc;
	xmlNodePtr cur;

	doc = xmlParseFile(filepath);

	if ( doc != NULL	&&	(cur = xmlDocGetRootElement(doc)) != NULL ) {
		do{
			if( xmlStrcmp(cur->name, (const xmlChar *) "Song") == 0 ){
				authorName = (char*)xmlGetProp(cur, (xmlChar *)"Author");
				if(DEBUG)printf("author: %s\n", authorName);
				break;
			}
			cur = cur->next;
	  	}while( cur );
	}
	return authorName;
}

char* GetAuthorNameJSON( char* filepath ){

	char* authorName = NULL;
	//TODO read the author's name from the json file.
	return authorName;
}

FILE* execFindCommand(const char* filename){

	char *command = NULL;	
	int _index;
	//"find " + sb->baseDirectory + " -name " + filename;
	command = malloc( strlen("find ") + strlen(sb->baseDirectory) + strlen(" -name ") + strlen(filename) );

	memcpy( command, "find ", strlen("find ") );
	_index = strlen("find ");
//	if( DEBUG )printf("\n%s", command );

	memcpy( command+_index, sb->baseDirectory , strlen(sb->baseDirectory) );
	_index += strlen(sb->baseDirectory);
//	if( DEBUG )printf("\n%s", command );

	memcpy( command+_index, " -name ", strlen(" -name ") );
	_index += strlen(" -name ");
//	if( DEBUG )printf("\n%s", command );

	memcpy( command+_index, filename, strlen(filename) );	
//	if( DEBUG )printf("\n%s", command );

	_index += strlen(filename);
	command[_index] = '\0';
	if( DEBUG )printf("final command:%s\n\n", command );

	FILE* cmdLine = popen (command, "r");
	free(command);
	return cmdLine;
}

char* SearchFileLocal( const char* filename, const char* author ){
	if( DEBUG )printf("\nSearching file localy...%s %s\n", filename, author );

	char *buff = NULL, *filepath = NULL;
	int ret = 0;
	size_t size = 0;

	FILE *cmdLine = execFindCommand(filename);

	while ( ret != -1 ){

		size = 10;
		buff = ( char* )malloc(size);
		ret = getline( &buff, &size, cmdLine );
		if( DEBUG )printf( "bufflength:%i,%i\nbuff:%s", (int) strlen(buff), (int) size, buff );

		if( ret != -1 && size > 2 ){

			buff[ strlen(buff) - 1 ] = '\0';
			char* tmpAuthor = GetAuthorNameXML( buff );
//TODO		char* tmpAuthor = GetAuthorNameJSON( buff );

			if( author == NULL || strcmp( tmpAuthor, author ) == 0 ){
				filepath = buff;
				if( tmpAuthor != NULL )free(tmpAuthor);
				break;
			}
			else{
				free(buff);
				if( tmpAuthor != NULL )free(tmpAuthor);
			}
		}
	}

	if( ! filepath )printf( "file not found on device\n" );
	fclose( cmdLine );
	return filepath;
}


char* gems_service_songbank_getFilePath(const char* filename, const char* author){

	char* filepath = SearchFileLocal( filename, author );

	if( filepath == NULL && sb->sbComm != NULL ){

		if(DEBUG)printf("searching network...\n");
		filepath = SearchFileNetwork(filename, author);
	}
	return filepath;
}

void gems_service_songbank_newConnection(const unsigned short aPort, MAbstractConnection* aConnection, int aConnectionId, void* aData){
	NewSBConnection( aPort, aConnection, aConnectionId );
}

char* SearchFileNetwork(const char* filename, const char* author){

	if(sb->sbComm){

		char* saveToFile = malloc( strlen(sb->baseDirectory) + strlen(filename) + 2);
		memcpy( saveToFile, sb->baseDirectory, strlen(sb->baseDirectory) );
		saveToFile[strlen(sb->baseDirectory)] = '/';
		memcpy( saveToFile + strlen(sb->baseDirectory) + 1, filename, strlen(filename) );
		saveToFile[strlen(sb->baseDirectory) + strlen(filename)+1] = '\0';

		if( GetFileFromNetwork(filename, author, saveToFile) )
			return saveToFile;
		else 
			return NULL;
	}
	else 
		return NULL;
}
/*
void main(void){
	char *filename = "song.xml", *author = "blabla";

	SongBank_setup("/home/fawad/jammo/jammo/src/gems/");
	char* result = GetFilePath( filename, author );
	
	if( !result )
		result = "no result";
	else
		printf( "result: %s\n", result );
	free(result);

}*/
