#include <tangle.h>
#include <stdlib.h>
#include <glib.h>

#include "../../meam/jammo-meam.h"
#include "../jammo-chum.h"
#include  "../../meam/jammo-sample.h"
#include "../jammo.h"

#include "createALLknots.h"
#include "check_path.h"
#include "config.h"
#include "create_inkml.h"
#include "pg_user_manager.h"
#include "buttons.h"
#include "config.h"
#include "screens.h"

#include "../jammo.h"
#include "../../cem/cem.h"
#include "../../gems/gems.h"

#define NUM_OF_CELLS 45
#define NUM_OF_SPOTS 9

int i_plus = 0; //Keeps the length of the password array

ClutterActor *myKnot[NUM_OF_CELLS];
ClutterActor *mySpot[NUM_OF_SPOTS];

ClutterActor *ls_point_container;
ClutterActor *display_error_actor; // DIsplay an image in case passowrd error

ClutterActor* loginname_text = NULL;

/**
 *
 */
static gboolean verify_path(ClutterActor* actor, ClutterEvent* event, gpointer data) {

	ClutterActor* container = CLUTTER_ACTOR(data);
	int *pp;
	int *p_arr = g_malloc(40 * sizeof(int));
	int i;
	int is_reset_passwd = get_is_reset_password();
	//is_reset_passwd   1 NORMAL LOGIN, 0 NEW PASSWORD

	pp = get_knot_buff_a();
	for (i = 0; i < i_plus; i++) {
		p_arr[i] = pp[i];
	}

	int *b;
	b = (int*) get_user_passwd();

	//int check=0;
	//g_print("\nARRAY:%d\n", p_arr[1]);
	gchar *test_pass;
	test_pass = pg_convert_points_to_string(p_arr, i_plus);

	//check=compareArrays(p_arr,b,i_plus);

	//New validation I keep the old one for now
	//make_reactive_all_knots(mySpot, NUM_OF_SPOTS, TRUE);
	//
	/* if (check==1)
	 {
	 g_print("\nWelcome :)\n");
	 //clutter_actor_hide(container);
	 create_ink_tale();
	 clutter_actor_show(jammo_get_actor_by_id("main-menu-view"));
	 clutter_actor_hide(jammo_get_actor_by_id("pen-gesture-view"));
	 }else{
	 g_print("Wrong pass\n");
	 // clutter_actor_show(display_error_actor);
	 pg_set_error_screen(container,PG_PASSWORD_ERROR);
	 //clutter_actor_hide(container);
	 }*/

	//check=0;
	g_free(p_arr);
	i_plus = 0;

	pg_validate_passwd(container, test_pass, is_reset_passwd);
	cem_add_to_log("login_screen.c: verify_path will return TRUE", J_LOG_DEBUG);
	return TRUE;
	//set_knots_buff(); //INITIALIZE THE BUFFER AGAIN
}

gboolean on_box_enter(ClutterActor *box, ClutterEvent *event,
		ClutterActor *emblem, gpointer data) {
	ClutterModifierType etype = clutter_event_get_state(event);
	#ifndef N900
	if (etype != 256)
		return FALSE;
	#endif

	clutter_actor_set_opacity(emblem, 254);
	/*
	 clutter_actor_animate(emblem, CLUTTER_EASE_IN_SINE, 10,
	 //Effects don't work on N900 coz of resources
	 //"rotation-angle-y", 360.0,
	 //"rotation-angle-z", 360.0,
	 "opacity", 254, NULL);
	 */
	gfloat x = 0;
	gfloat y = 0;
	clutter_event_get_coords(event, &x, &y);
	set_xy_in_xml(x, y);

	return FALSE;
}

static gboolean on_spot_enter(ClutterActor *box, ClutterEvent *event, gpointer data) {
	//NO OVERFLOW

	ClutterActor* container = CLUTTER_ACTOR(data);
	ClutterModifierType etype = clutter_event_get_state(event);
	g_print("%d\n", etype);

	/* TODO Reuse memory don't allocate over and over. */
	if (i_plus == 40) {
		initialize_knots_buffer();
		i_plus = 0;
	}
	int spot_id;
	spot_id = atoi(clutter_actor_get_name(box));
	fill_knots_buff(spot_id, 2, i_plus);
	int *pp;
	int p;
	pp = get_knot_buff_a();
	p = pp[0];
	i_plus = i_plus + 1;
	int is_reset_passwd = get_is_reset_password();
	if (is_reset_passwd == 1) {
		pg_set_msg_from_image(container, PG_RESET_PASSWD_MESSAGE, 600, 350);
	}

	return FALSE;
}

static gboolean on_box_leave(ClutterActor *box, ClutterEvent *event, gpointer data) {
	ClutterActor* emblem = CLUTTER_ACTOR(data);
	clutter_actor_set_opacity(emblem, 0);
	/*
	 clutter_actor_animate(emblem, CLUTTER_EASE_IN_SINE, 200,
	 //Effects don't work on N900
	 //CLUTTER_EASE_IN_CUBIC
	 //"x", 100.0,
	 //"y", 500.0,
	 //"rotation-angle-y", 720.0,
	 //"rotation-angle-z", 720.0,
	 "opacity", 0, NULL);
	 */
	//clutter_actor_destroy(emblem);
	return FALSE;
}

/* Not used.
 static gboolean show_points_container(ClutterActor *box, ClutterEvent *event,
 ClutterActor *container) {

 //clutter_actor_show(container);
 //clutter_actor_hide(display_error_actor);
 return FALSE;
 }
 */

void login_screen() {
	//Initialize buffer for storing activated knots
	initialize_knots_buffer();
	create_ink_head();

	//Print version
	gchar* message = g_strdup_printf("pen-gesture version '%s'", PG_VERSION);
	cem_add_to_log(message, J_LOG_INFO);
	g_free(message);

	//pg_read_passwd_from_file();
	//g_print("IS NEW PASSWORD:\n",is_new_passwd);

	// Get the stage created
	ClutterActor *stage = jammo_get_actor_by_id("pen-gesture-view");
	clutter_actor_set_reactive(stage, TRUE);
	clutter_actor_set_size (stage, 800, 480);

	// Add Background to the stage
	gchar* pg_directory_path = PG_IMAGES_DIR;
	gchar* filename0 = "bg.png";
	//FIXME: this is never free'ed.
	gchar* path0 = g_build_filename(pg_directory_path, filename0, NULL);
	//FIXME: this is never free'ed.
	ClutterActor *rect0 = tangle_texture_new(path0);

	// Setup background actor
	clutter_actor_set_position(rect0, 0, 0);
	// if only the parent of all actors is shown then this is not required.
	// clutter_actor_show(rect0);
	clutter_container_add_actor(CLUTTER_CONTAINER (stage), rect0);

	// Setup a container for the grid.
	ls_point_container = clutter_group_new();
	clutter_actor_set_position(ls_point_container, 0, 0);
	clutter_container_add_actor(CLUTTER_CONTAINER (stage), ls_point_container);
	 //FIXME: this is never free'ed.
	clutter_actor_set_name(CLUTTER_ACTOR(ls_point_container), "point_container");
	// Create Buttons
	button_exit_set(stage);

	// button_new_password_set(stage);
	// display_error_actor = button_error_set(stage);
	// clutter_actor_hide(display_error_actor);
	// Create knots and signals for every knot
	// Only straight lines are permitted

	int ii = 0;
	int jj = 0;
	int acts = 0;
	for (ii = 40; ii < 370; ii = ii + 40) {
		for (jj = 40; jj < 370; jj = jj + 40) {
			if ((ii == 40 || ii == 200 || ii == 360 || jj == 40 || jj == 200
					|| jj == 360)) {
				myKnot[acts] = create_knot_with_pos(ls_point_container, ii, jj);
				//FIXME: this is never free'ed.
				g_signal_connect(myKnot[acts], "motion-event", G_CALLBACK (on_box_enter), myKnot[acts]);
				//FIXME: this is never free'ed.
				g_signal_connect(myKnot[acts], "button-press-event", G_CALLBACK (on_box_enter), myKnot[acts]);
				//FIXME: this is never free'ed.
				g_signal_connect(stage, "button-release-event", G_CALLBACK (on_box_leave), myKnot[acts]);
				acts++;
			}
		}
	}

	create_all_knots(ls_point_container, mySpot, G_CALLBACK(on_spot_enter), G_CALLBACK(verify_path));

	pg_set_select_option_screen(stage);
	
	gchar* loginname = gems_get_login_username();
	if(!loginname) loginname = g_strdup("defaultuser");
	
	ClutterColor uname_color = { 0xff, 0xff, 0xff, 0x99 };
	loginname_text = clutter_text_new_full("Sans 18",loginname,&uname_color);
	clutter_actor_set_size(loginname_text,50,50);
	clutter_actor_set_position(loginname_text,10,10);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage),loginname_text);
	clutter_actor_hide(loginname_text);
	
	g_free(loginname);

	clutter_actor_show(stage);
}

void login_screen_set_login_name(gchar* loginname)
{
	if(loginname && loginname_text)
	{
		clutter_text_set_text((ClutterText*)loginname_text,loginname);
		clutter_actor_show(loginname_text);
	}
}
