/*
License: GPLv2, read more from COPYING

This file contains the functionality of mysongs menu.
 */
#include <tangle.h>
#include <string.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"
#include "mysongs.h"
#include "community_utilities.h"
#include "../../gems/community_server_functions.h"
#include "record_cover_tool.h"
#include "../../configure.h"
#include "../../cem/cem.h"
#include "../file_helper.h"
#include "../jammo-mentor.h"
#include "single_thread.h"
#include "sequencer.h" //From mysongs to sequencer

ClutterContainer* remove_view = 0;
ClutterColor mysongs_text_color = { 255, 255, 255, 255 };
static list_type songlist = {0, 0};
static gboolean removing_song = FALSE;
static gchar* command;
ClutterActor *currentlyModifiedLabel = 0;

void start_mysongs()
{
	cem_add_to_log("Starting Mysongs", J_LOG_DEBUG);

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* mysongs_view = jammo_get_actor_by_id("mysongs-view");

	if(mysongs_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(mysongs_view));
		songlist.list = 0;
		mysongs_refresh_list();
	}

	else 	cem_add_to_log("can't find 'mysongs-view' ", J_LOG_ERROR);
}

void mysongs_end_mysongs(){

	clear_container(songlist.list);

	if(removing_song){
		clear_container(remove_view);
		removing_song = FALSE;
	}		

}


gboolean mysongs_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	mysongs_end_mysongs();
	start_communitymenu();
	return TRUE;
}

gboolean mysongs_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	mysongs_end_mysongs();
	startmenu_goto_startmenu(tanglebutton, none);
	return TRUE;
}

gboolean mysongs_mentor_clicked (TangleButton *tanglebutton, gpointer data)   
{
	cem_add_to_log("mentor clicked", J_LOG_DEBUG);
	return TRUE;
}

void start_sequencer_with_this_file(ClutterActor *actor, gpointer none) 
{
	mysongs_end_mysongs();

	const char* filename = clutter_actor_get_name(actor);
	sequencer_start_with_file((char*)filename);
}

/*
 * Filename: contains fullpath
 * Type:
 * 0=work in progress (project)
 * 1=finalized work (no editing anymore)
 * 2=workshop in progress
 * 3=song is sent to jammosongs
 *
 *TODO: filename is just printed.
 */
gboolean mysongs_add_loop_to_list(char* filename, int type)
{
	ClutterActor *colorbar 		= 0;
	ClutterActor *label 		= 0;
	ClutterActor *remove_button 	= 0;
	ClutterActor *text 		= 0;
	ClutterActor *infoButton 	= 0;
	ClutterActor *textButton 	= 0;
	ClutterActor *arrowImage 	= 0;
	ClutterContainer *listContainer = 0;
	ClutterActor *labelButton = 0;
	ClutterActor *labelBg = 0;
	gchar* path;
	char colorbar_path[80] = DATA_DIR;
	char infoButton_path[100] = DATA_DIR;

	switch (type)
	{
		case 0:
			strcat(colorbar_path, "/communitymenu/colorbar1.png");
			colorbar = tangle_texture_new(colorbar_path);
			break;
		case 1:
			strcat(colorbar_path, "/communitymenu/colorbar4.png");
			colorbar = tangle_texture_new(colorbar_path);
			break;
		case 2:
			strcat(colorbar_path, "/communitymenu/colorbar5.png");
			colorbar = tangle_texture_new(colorbar_path);
			break;
		case 3:
			strcat(colorbar_path, "/communitymenu/colorbar7.png");
			colorbar = tangle_texture_new(colorbar_path);
			break;
		default:
			strcat(colorbar_path, "/communitymenu/colorbar12.png");
			colorbar = tangle_texture_new(colorbar_path);
			break;
	}

	int i 		= 0;
	int j 		= 0;
	int type_length = 0;
	int path_length = 0;
	int length	= strlen(filename);

	char temp[length];
	char filename_for_textbutton[length];
	strcpy(temp, filename);

	if(type == 0){ //projects
		path_length = strlen(configure_get_projects_directory());
		type_length = 5; //.json
	}else if(type == 1 || type == 3){ //songs
		path_length = strlen(configure_get_finalized_directory());
		type_length = 4; //.ogg
	}
		
	for(i = path_length + 1; i < length-type_length; i++)
	{
		filename_for_textbutton[j] = temp[i];
		j++;
	}
	filename_for_textbutton[j] = 0;

	//TODO: change gems_profile_manager_get_userid(NULL) to use proper user id

	command = g_strdup_printf("ls %s/label_%d_%s.csv 1> /dev/null 2> /dev/null", configure_get_jammo_directory(), 
					gems_profile_manager_get_userid(NULL), filename_for_textbutton);

	path = g_strdup_printf("%s/label_%d_%s.csv", configure_get_jammo_directory(), gems_profile_manager_get_userid(NULL), 
					filename_for_textbutton);

	gchar* labelButton_filename = g_strdup_printf("%s/communitymenu/community_cdlabel_small.png", DATA_DIR);

	if(file_exist(path)/*system(command) == 0*/){ // labelfile already exists
		
		label =  clutter_group_new();
		
		labelBg = clutter_rectangle_new_with_color(clutter_color_new(255,255,255,255));
		clutter_actor_set_size(labelBg, 50, 50);
		clutter_container_add_actor(CLUTTER_CONTAINER(label), labelBg);
				
		FILE *file = fopen(path, "r");
		char data[200];
		if(fread(data, sizeof(char), 200, file) != 0){
		
			strtok(data, ",");
			strtok(NULL, ",");
			char *instrument;
			instrument = strtok(NULL, ",");
		
			ClutterActor *image = tangle_texture_new(instrument);
			clutter_actor_set_size(image, 40, 40);
			clutter_actor_set_position(image, 5, 5);
		
			clutter_container_add_actor(CLUTTER_CONTAINER(label), image);
		}
		fclose(file);

		labelButton = tangle_button_new_with_background_actor(label);
		
		clutter_actor_set_size(labelButton, 50, 50);
		clutter_actor_set_position(labelButton, 500, 15);

	}else{
		labelButton = tangle_button_new_with_background_actor(tangle_texture_new(labelButton_filename));
		clutter_actor_set_position(labelButton, 500, 15);
	}
	g_free(command);
	g_free(labelButton_filename);

	gchar* remove_button_filename = g_strdup_printf("%s/backingtracks/button_cancel.png", DATA_DIR);

	remove_button = tangle_button_new_with_background_actor(tangle_texture_new(remove_button_filename));

	text = clutter_text_new_full(TEXT_NORMAL, filename_for_textbutton, &mysongs_text_color);

	textButton = tangle_button_new_with_background_actor(text);
	clutter_actor_set_name(textButton,filename);

	clutter_text_set_editable (CLUTTER_TEXT(text), FALSE);
	clutter_text_set_max_length (CLUTTER_TEXT(text), 40);
	clutter_text_set_single_line_mode (CLUTTER_TEXT(text), TRUE);

	gchar* arrowImage_filename = g_strdup_printf("%s/communitymenu/community_rightarrow.png", DATA_DIR);
	arrowImage = tangle_texture_new(arrowImage_filename);

	listContainer = CLUTTER_CONTAINER(clutter_group_new());

	//Additinally of type, there can be another icon e.g. video missing, new comments
	switch(type)
	{
		case 0:
			strcat(infoButton_path, "/communitymenu/community_backtosequencer.png");
			infoButton = tangle_button_new_with_background_actor(tangle_texture_new(infoButton_path));

			g_signal_connect(CLUTTER_ACTOR(infoButton), "clicked", G_CALLBACK (start_sequencer_with_this_file), CLUTTER_ACTOR(infoButton));
			clutter_actor_set_position(infoButton, 690, 7);
			break;
		case 1:
			strcat(infoButton_path, "/communitymenu/community_umsic_icon.png");
			infoButton = tangle_button_new_with_background_actor(tangle_texture_new(infoButton_path));

			clutter_actor_set_position(infoButton, 690, 15);

			g_signal_connect_swapped(CLUTTER_ACTOR(infoButton), "clicked", G_CALLBACK(mysongs_comment), CLUTTER_ACTOR(infoButton));
			
			break;
		case 3:
			strcat(infoButton_path, "/communitymenu/community_comment_icon.png");
			infoButton = tangle_button_new_with_background_actor(tangle_texture_new(infoButton_path));

			g_signal_connect(CLUTTER_ACTOR(infoButton), "clicked", G_CALLBACK(mysongs_get_comments), CLUTTER_ACTOR(infoButton));
			clutter_actor_set_position(infoButton, 690, 15);				
			break;
	}

	if(colorbar == NULL || infoButton == NULL || arrowImage == NULL){
		cem_add_to_log("Failed to load Colorbar, Arrowimage or infoButton", J_LOG_ERROR);
		return FALSE;	
	}

	if(songlist.listItemHeight == 0) 
		songlist.listItemHeight = clutter_actor_get_height(colorbar);

	clutter_container_add_actor(listContainer, colorbar);	//Add components inside the container

	if(labelButton != 0)
	{
		clutter_container_add_actor(listContainer, CLUTTER_ACTOR(labelButton));
		clutter_actor_raise(labelButton, colorbar);
		clutter_actor_set_name(labelButton, path);
		g_signal_connect_swapped(CLUTTER_ACTOR(labelButton), "clicked", G_CALLBACK(mysongs_label_button_clicked), CLUTTER_ACTOR(labelButton));
	}
	clutter_actor_set_name(infoButton,filename);

	clutter_actor_set_name(remove_button,filename);
	clutter_actor_set_position(remove_button, 580, 15);
	clutter_container_add_actor(listContainer, remove_button);
	g_free(remove_button_filename);

	clutter_actor_set_position(textButton, 60, 23);		
	clutter_container_add_actor(listContainer, textButton);	
	
	clutter_actor_set_position(arrowImage, 653, 15);
	clutter_container_add_actor(listContainer, arrowImage);
	g_free(arrowImage_filename);
	
	clutter_container_add_actor(listContainer, CLUTTER_ACTOR(infoButton));

	g_signal_connect(textButton, "clicked", G_CALLBACK(song_on_clicked_function), NULL);
	g_object_set(textButton, "hold-timeout", 1500, NULL);
	g_signal_connect(textButton, "held", G_CALLBACK(song_on_held_function), NULL);

	g_signal_connect_swapped(CLUTTER_ACTOR(remove_button), "clicked", G_CALLBACK(mysongs_remove_song_view), CLUTTER_ACTOR(textButton));
	g_signal_connect_swapped(CLUTTER_ACTOR(label), "clicked", G_CALLBACK(show_song_label), filename);	

	clutter_container_add_actor(songlist.list, CLUTTER_ACTOR(listContainer));
	
	g_free(path);

	return TRUE;
}

void mysongs_get_comments(ClutterActor* song)
{

	GList *messages = 0;
	
	//TODO: get comments of the song from the server
	
	mysongs_end_mysongs();
	tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("mysongs-view")));
	
	start_thread_view(messages, "mysongs", NULL, 0);
}

void mysongs_comment(ClutterActor *actor)
{
	const gchar * filename = clutter_actor_get_name(actor);

	gchar * message = g_strdup_printf("Sending song \"%s\" to JamMo Songs...", filename);
	cem_add_to_log(message, J_LOG_DEBUG);
	g_free(message);

	//sendJammoFile(filename); //TODO: Send song to JamMo Songs
}


void mysongs_delete_song(ClutterActor *actor)
{
	const gchar * filename = clutter_actor_get_name(actor);
	gchar* suffix = strrchr(filename, '.');
	gchar songname[99];
	gchar* temp;
	int i;

	for(temp = strrchr(filename, '/'), i = 0; temp+1 != suffix; i++){
		temp++;
		songname[i] = *temp;
	}
	songname[i] = 0;
	
	//TODO: change gems_profile_manager_get_userid(NULL) to use proper user id
	gchar* label = g_strdup_printf("%s/label_%d_%s.csv", configure_get_jammo_directory(), gems_profile_manager_get_userid(NULL), songname);

	gchar * message = g_strdup_printf("Removing %s...", filename);
	cem_add_to_log(message, J_LOG_DEBUG);
	g_free(message);

	if(remove(filename) != 0)
    		cem_add_to_log("Error deleting file", J_LOG_ERROR);
  	else
  		cem_add_to_log("File successfully deleted", J_LOG_ERROR);
    		
    	if(remove(label) != 0)
    		cem_add_to_log("Error deleting labelfile", J_LOG_ERROR);
    	else	
    		cem_add_to_log("Labelfile succesfully deleted", J_LOG_ERROR);		
    		
	g_free(label);

	clear_container(songlist.list);
	clear_container(remove_view);
	removing_song = FALSE;
	mysongs_refresh_list();
}


void mysongs_cancel_song_delete(ClutterActor *actor)
{
	removing_song = FALSE;
	clear_container(remove_view);
}

void mysongs_remove_song_view(ClutterActor *actor){

	if(removing_song) return;

	removing_song = TRUE;
	remove_view = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-container"));

	ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());
	gchar* ok_button_filename = g_strdup_printf("%s/backingtracks/button_ok.png", DATA_DIR);
	gchar* cancel_button_filename = g_strdup_printf("%s/backingtracks/button_cancel.png", DATA_DIR);

	ClutterActor *text = CLUTTER_ACTOR(clutter_text_new_full(TEXT_CAPTION, "Remove?", &mysongs_text_color));
	clutter_actor_set_position(text, 20, 60);
	clutter_container_add_actor(listContainer, text);
	
	ClutterActor *ok_button = tangle_button_new_with_background_actor(tangle_texture_new(ok_button_filename));

	ClutterActor *cancel_button = tangle_button_new_with_background_actor(tangle_texture_new(cancel_button_filename));

	clutter_actor_set_position(ok_button, 170, 40);
	clutter_container_add_actor(listContainer, ok_button);

	clutter_actor_set_position(cancel_button, 260, 60);
	clutter_container_add_actor(listContainer, cancel_button);

	g_signal_connect_swapped(CLUTTER_ACTOR(ok_button), "clicked", G_CALLBACK(mysongs_delete_song), CLUTTER_ACTOR(actor));
	g_signal_connect_swapped(CLUTTER_ACTOR(cancel_button), "clicked", G_CALLBACK(mysongs_cancel_song_delete), CLUTTER_CONTAINER(remove_view));

	clutter_container_add_actor(remove_view, CLUTTER_ACTOR(listContainer));

	g_free(ok_button_filename);
	g_free(cancel_button_filename);
}

void mysongs_label_button_clicked(ClutterActor *label){

	currentlyModifiedLabel = label;
	
	start_record_cover_tool(clutter_actor_get_name(label));
}


void mysongs_update_label_button(const gchar* path){

	currentlyModifiedLabel = tangle_button_new_with_background_actor(clutter_rectangle_new_with_color(clutter_color_new(255,255, 255,255)));
	mysongs_refresh_list();
}

void mysongs_refresh_list()
{
	int numberOfLoops = 0;
	GList* l = NULL; //Iterator
	GList* projects = NULL;
	GList* finalized = NULL;

	cem_add_to_log("Refreshing list...", J_LOG_DEBUG);
	
	clear_container(songlist.list);

	projects = file_helper_get_all_files(configure_get_projects_directory()); //Project-files
	finalized = file_helper_get_all_files(configure_get_finalized_directory()); //Audio-files

	numberOfLoops += g_list_length (projects) + g_list_length (finalized);

	if(numberOfLoops > 5)
		songlist.list = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-scrollable"));	

	else	songlist.list = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-unscrollable"));	

	clutter_actor_lower(CLUTTER_ACTOR(songlist.list),jammo_get_actor_by_id("mysongs_down-index"));

	for (l = projects; l; l = l->next)
		mysongs_add_loop_to_list(l->data, 0); //0 = Project-file

	for (l = finalized; l; l = l->next)
		mysongs_add_loop_to_list(l->data, 1); //1 = Finalized file

	if(numberOfLoops <= 6)
		clutter_actor_set_height(CLUTTER_ACTOR(songlist.list), songlist.listItemHeight * numberOfLoops);
	else	
		clutter_actor_set_height(CLUTTER_ACTOR(songlist.list), songlist.listItemHeight * 6);
	
	ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(songlist.list), TANGLE_TYPE_SCROLL_ACTION);

	g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(community_autoscroll_to_correct_pos), songlist.list); // 2 warnings happens here


}
