/*
License: GPLv2, read more from COPYING

This file contains the functionality of discuss menu.
 */

#ifndef DISCUSS_H_
#define DISCUSS_H_

#include <glib.h>
#include <glib-object.h>

#define MAX_THREADS 31

typedef struct {
	gchar title[40];
}thread_type;

void start_discuss();
gboolean addDiscussion(char* name, int num);
gboolean addThread(char* name, int num, guint32 user_id);
ClutterActor *create_line(int y, int length, int size, ClutterContainer *cont);
gboolean discuss_change_to_discussion_view(TangleActor *actor, gpointer data);
gboolean discuss_change_to_discussion_threads_view(TangleActor *actor, gpointer data);
void getAllTopics();
void getAllThreads();
void getAllMessages(gchar *id);
void getDiscussion(ClutterActor *element);
void getThread(ClutterActor *element);
void start_discussionthreads();
void start_addthread_view();
gboolean discuss_change_to_add_thread_view(TangleActor *actor, gpointer data);
void add_new_thread();
void end_discuss();

#endif 
