#include <tangle.h>
#include <clutter/clutter.h>
#include <stdlib.h> //For exit()

#include "../jammo.h"  //jammo_get_actor_by_id
#include "../jammo-mentor.h"
#include "../../cem/cem.h"

static void end_jammo(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer){
	cem_add_to_log("Quitted by player", J_LOG_INFO);
	clutter_main_quit();
}

void quitconfirmation_quit_confirmed(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	cem_add_to_log("Quit confirmed", J_LOG_USER_ACTION);
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "quit_byebye.spx", end_jammo, NULL);
}

void quitconfirmation_mentor_action(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	//Hide mentor (withoud hiding)
	jammo_mentor_set_active_scale(jammo_mentor_get_default(),0.0001);
	jammo_mentor_set_standby_scale(jammo_mentor_get_default(),0.0001);

	jammo_mentor_speak(jammo_mentor_get_default(), "quit_confirmation.spx");
	jammo_mentor_set_idle_speech(jammo_mentor_get_default(), "quit_confirmation.spx");
}

void quitconfirmation_cancel_action (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	cem_add_to_log("Quit canceled", J_LOG_USER_ACTION);
	jammo_mentor_set_active_scale(jammo_mentor_get_default(),1.0);
	jammo_mentor_set_standby_scale(jammo_mentor_get_default(),0.25);

	jammo_mentor_set_idle_speech(jammo_mentor_get_default(), "main_menu_idle.spx");
	tangle_action_execute(TANGLE_ACTION(jammo_get_object_by_id("quitconfirmation-cancel-action2")));
}
