/*
 * community_server_functions.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu, Lappeenranta University of Technology
 *
 * Authors: Tommi Kallonen <tommi.kallonen@lut.fi>
 */
#include "autogenerated_functions/jammo_soapH.h" // obtain the generated stub  
#include "autogenerated_functions/getJammoSongDataBinding.nsmap" // obtain the generated XML namespace mapping table for the service  
#include <glib/gstdio.h>
#include "community_server_functions.h"


gboolean getJammoData(char *songname, char *userid, char *filename, char *description, char *date, char *json)
{
	struct soap *soap = soap_new();
   	char *returnvalue; 
   	char ** return_;

   	return_=&returnvalue;
   	if (soap_call_ns1__getJammoData(soap, NULL, NULL, songname, userid, filename, description, date, json, return_)== 		SOAP_OK)
	printf("Got a response: %s\n", return_[0]);
  	else // an error occurred  
	{
      		soap_print_fault(soap, stderr); // display the SOAP fault on the stderr stream  
		return FALSE;
	}

	soap_end(soap);
   	soap_free(soap); 
   	returnvalue=NULL; 
	return TRUE;
}

gboolean getJammoSongData(char *jammoSongID)
{
	struct soap *soap = soap_new(); 
   	char *returnvalue;
   	char ** return_;

   	return_=&returnvalue;
	 
   	if (soap_call_ns1__getJammoSongData(soap,NULL, NULL, jammoSongID, return_)== SOAP_OK)
		printf("Got a response: %s\n", return_[0]);
   	else // an error occurred  
	{
      		soap_print_fault(soap, stderr); // display the SOAP fault on the stderr stream  
		return FALSE;
	}

	soap_end(soap);
   	soap_free(soap);
   	returnvalue=NULL; 

	return TRUE;
}


gboolean sendJammoFile(gchar *filename)
{
	struct soap *soap = soap_new(); 
   	char *returnvalue;
   	char ** return_;
   	gchar* filecontents=NULL;
   	gchar* filecontents64=NULL;
   	gsize length;
   	GError *file_error=NULL;

   	return_=&returnvalue;

 
	if(g_file_get_contents (filename, &filecontents, &length, &file_error))
	{

		printf("%s, %d\n",filecontents, length);
		filecontents64= g_base64_encode((const guchar *)filecontents, length);

		if (soap_call_sendfile__transfer_USCOREinkml_USCOREfile(soap, NULL, NULL, filename, filecontents64, return_)== SOAP_OK)
			printf("Got a response: %s\n", return_[0]);
   		else // an error occurred  
		{
      			soap_print_fault(soap, stderr); // display the SOAP fault on the stderr stream
			return FALSE;
		}

	}
   	else
   	{
		fprintf (stderr, "Unable to read file: %s\n", file_error->message);
    		g_error_free (file_error);
		return FALSE;
   	}

	



   	soap_end(soap);
   	soap_free(soap);  
   	returnvalue=NULL; 
   	return TRUE;


}
