/*
License: GPLv2, read more from COPYING

This file contains the functionality of help menu.
 */
#include <tangle.h>
#include <string.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"
#include "mysongs.h"
#include "community_utilities.h"
#include "../../gems/community_server_functions.h"
#include "record_cover_tool.h"
#include "../../configure.h"
#include "../file_helper.h"
#include "../jammo-mentor.h"
#include "single_thread.h"
#include "sequencer.h" //From mysongs to sequencer

ClutterContainer* remove_view = 0;
ClutterColor mysongs_text_color = { 255, 255, 255, 255 };
static list_type songlist = {0, 0};
static gboolean removing_song = FALSE;
static gchar* command;
ClutterActor *currentlyModifiedLabel = 0;

void start_mysongs()
{
	puts("Starting Mysongs\n");

	ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* mysongs_view = jammo_get_actor_by_id("mysongs-view");

	if(mysongs_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(mysongs_view));
		mysongs_refresh_list();
	}

	else 	puts("can't find 'mysongs-view' ");
}

void mysongs_end_mysongs(){

	clear_container(songlist.list);

	if(removing_song){
		clear_container(remove_view);
		removing_song = FALSE;
	}		


}


void mysongs_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	mysongs_end_mysongs();
	start_communitymenu();
}

void mysongs_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	mysongs_end_mysongs();
	startmenu_goto_startmenu(tanglebutton, none);
}

gboolean mysongs_mentor_clicked (TangleButton *tanglebutton, gpointer data)   
{
	printf("mentor clicked\n");
	return TRUE;
}

void start_sequencer_with_this_file(ClutterActor *actor, gpointer none) 
{
	mysongs_end_mysongs();

	const char* filename = clutter_actor_get_name(actor);
	sequencer_start_with_file((char*)filename);
}

/*
 * Filename: contains fullpath
 * Type:
 * 0=work in progress (project)
 * 1=finalized work (no editing anymore)
 * 2=workshop in progress
 * 3=song is sent to jammosongs
 *
 *TODO: filename is just printed.
 */
gboolean mysongs_add_loop_to_list(char* filename, int type)
{
	ClutterActor *colorbar 		= 0;
	ClutterActor *label 		= 0;
	ClutterActor *remove_button 	= 0;
	ClutterActor *text 		= 0;
	ClutterActor *infoButton 	= 0;
	ClutterActor *textButton 	= 0;
	ClutterActor *arrowImage 	= 0;
	ClutterContainer *listContainer = 0;
	ClutterActor *labelButton = 0;
	ClutterActor *labelBg = 0;
	gchar* path;

	switch (type)
	{
		case 0:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar1.png",NULL);
			break;
		case 1:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar4.png",NULL);
			break;
		case 2:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar5.png",NULL);
			break;
		case 3:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar7.png",NULL);
			break;
		default:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar12.png",NULL);
			break;
	}

	int i 		= 0;
	int j 		= 0;
	int type_length = 0;
	int path_length = 0;
	int length	= strlen(filename);

	char temp[length];
	char filename_for_textbutton[length];
	strcpy(temp, filename);

	if(type == 0){ //projects
		path_length = strlen(configure_get_projects_directory());
		type_length = 5; //.json
	}else if(type == 1 || type == 3){ //songs
		path_length = strlen(configure_get_finalized_directory());
		type_length = 4; //.ogg
	}
		
	for(i = path_length + 1; i < length-type_length; i++)
	{
		filename_for_textbutton[j] = temp[i];
		j++;
	}
	filename_for_textbutton[j] = 0;

	command = g_strdup_printf("ls %s/label_%d_%s.csv 1> /dev/null 2> /dev/null", configure_get_jammo_directory(), 
					gems_profile_manager_get_userid(NULL), filename_for_textbutton);
	path = g_strdup_printf("%s/label_%d_%s.csv", configure_get_jammo_directory(), gems_profile_manager_get_userid(NULL), filename_for_textbutton);

	//NOTE: gems_profile_manager_get_userid(NULL) gives new id every time jammo is restarted!

	puts(command);
	puts(path);

	if(file_exist(path)/*system(command) == 0*/){ //labelfile already exists
		label =  clutter_group_new();
		
		labelBg = clutter_rectangle_new_with_color(clutter_color_new(255,255,255,255));
		clutter_actor_set_size(labelBg, 50, 50);
		clutter_container_add_actor(CLUTTER_CONTAINER(label), labelBg);
				
		FILE *file = fopen(path, "r");
		char data[200];
		if(fread(data, sizeof(char), 200, file) != 0){
		
			strtok(data, ",");
			strtok(NULL, ",");
			char *instrument;
			instrument = strtok(NULL, ",");
		
			ClutterActor *image = clutter_texture_new_from_file(instrument, NULL);
			clutter_actor_set_size(image, 40, 40);
			clutter_actor_set_position(image, 5, 5);
		
			clutter_container_add_actor(CLUTTER_CONTAINER(label), image);
		}
		fclose(file);

		labelButton = tangle_button_new_with_background_actor(label);
		
		clutter_actor_set_size(labelButton, 50, 50);
		clutter_actor_set_position(labelButton, 500, 15);
	}else{

		labelButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file("/opt/jammo/communitymenu/community_cdlabel_small.png", NULL));
		clutter_actor_set_position(labelButton, 500, 15);
	}
	g_free(command);

	remove_button = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
			"/opt/jammo/backingtracks/button_cancel.png", NULL));

	text = clutter_text_new_full(TEXT_NORMAL, filename_for_textbutton, &mysongs_text_color);

	textButton = tangle_button_new_with_background_actor(text);
	clutter_actor_set_name(textButton,filename);

	clutter_text_set_editable (CLUTTER_TEXT(text), FALSE);
	clutter_text_set_max_length (CLUTTER_TEXT(text), 99);
	clutter_text_set_single_line_mode (CLUTTER_TEXT(text), TRUE);

	arrowImage = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_rightarrow.png", NULL);

	listContainer = CLUTTER_CONTAINER(clutter_group_new());

	//Additinally of type, there can be another icon e.g. video missing, new comments
	switch(type)
	{
		case 0:
			infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_backtosequencer.png", NULL));

			g_signal_connect (CLUTTER_ACTOR(infoButton), "clicked", G_CALLBACK (start_sequencer_with_this_file), NULL);
			clutter_actor_set_position(infoButton, 690, 7);
			break;
		case 1:
			infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_umsic_icon.png", NULL));

			clutter_actor_set_position(infoButton, 690, 15);

			g_signal_connect_swapped(CLUTTER_ACTOR(infoButton), "clicked", G_CALLBACK(mysongs_comment),  infoButton);
			
			break;
		case 3:
			infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_comment_icon.png", NULL));

			g_signal_connect(infoButton, "clicked", G_CALLBACK(mysongs_get_comments), NULL);
			clutter_actor_set_position(infoButton, 690, 15);				
			break;
	}
	if(colorbar == NULL || infoButton == NULL || arrowImage == NULL){
		printf("Failed to load Colorbar, Arrowimage or infoButton\n");
		return FALSE;	
	}

	if(songlist.listItemHeight == 0) 
		songlist.listItemHeight = clutter_actor_get_height(colorbar);

	clutter_container_add_actor(listContainer, colorbar);	//Add components inside the container
	//clutter_actor_set_position(infoButton, 690, 15);

	if(labelButton != 0)
	{
		clutter_container_add_actor(listContainer, labelButton);
		clutter_actor_raise(labelButton, colorbar);
		clutter_actor_set_name(labelButton, path);
		g_signal_connect_swapped(labelButton, "clicked", G_CALLBACK(mysongs_label_button_clicked), labelButton);
	}
	clutter_actor_set_name(infoButton,filename);
	clutter_container_add_actor(listContainer, infoButton);

	clutter_actor_set_name(remove_button,filename);
	clutter_actor_set_position(remove_button, 580, 15);
	clutter_container_add_actor(listContainer, remove_button);

	clutter_actor_set_position(textButton, 60, 23);			
	clutter_container_add_actor(listContainer, textButton);
	
	clutter_actor_set_position(arrowImage, 653, 15);
	clutter_container_add_actor(listContainer, arrowImage);
	
	clutter_container_add_actor(listContainer, infoButton);
	
	g_signal_connect_swapped(textButton, "button-press-event", G_CALLBACK(song_name_press_action), textButton);
	g_signal_connect_swapped(textButton, "button-release-event", G_CALLBACK(song_name_release_action), textButton);

	g_signal_connect_swapped(CLUTTER_ACTOR(remove_button), "clicked", G_CALLBACK(mysongs_remove_song_view), textButton);
	g_signal_connect_swapped(label, "clicked", G_CALLBACK(show_song_label), filename);	

	clutter_container_add_actor(songlist.list, CLUTTER_ACTOR(listContainer));
	
	g_free(path);

	return TRUE;
}

void mysongs_get_comments(ClutterActor* song)
{

	GList *messages = 0;
	
	//TODO: get comments of the song from the server
	
	mysongs_end_mysongs();
	tangle_actor_hide_animated(TANGLE_ACTOR(jammo_get_actor_by_id("mysongs-view")));
	
	start_thread_view(messages, "mysongs", NULL, 0);
}

void mysongs_comment(ClutterActor *actor)
{
	/*GList *children = clutter_container_get_children(songlist.list); //Get list of actors
	GList *node = children;

	int index = 0;
	int found = 0;
	
	while(node != NULL)
	{
		index++;

		if(actor == node->data)
		{*/
			//TO-DO: Send song to JamMo Songs
			const gchar * filename = clutter_actor_get_name(actor);
			//printf("Found it. Index %d\n", index);
			printf("Song is: %s\n", filename);
			printf("Sending song to JamMo Songs...\n");

			//sendJammoFile(filename);

		/*	found = 1;
			break;
		}

		node = node->next;
	}

	g_list_free(children);*/
}


void mysongs_delete_song(ClutterActor *actor)
{
	const gchar * filename = clutter_actor_get_name(actor);
	gchar* suffix = strrchr(filename, '.');
	gchar songname[99];
	gchar* temp;
	int i;

	for(temp = strrchr(filename, '/'), i = 0; temp+1 != suffix; i++){
		temp++;
		songname[i] = *temp;
	}
	songname[i] = 0;
	
	gchar* label = g_strdup_printf("%s/label_%d_%s.csv", configure_get_jammo_directory(), gems_profile_manager_get_userid(NULL), songname);

	printf("Removing %s...\n", filename);

	if(remove(filename) != 0)
    		printf("Error deleting file\n");
  	else
  		printf("File successfully deleted\n");
    		
    	if(remove(label) != 0)
    		printf("Error deleting labelfile\n");
    	else	
    		printf("Labelfile succesfully deleted\n");		
    		
	g_free(label);

	clear_container(songlist.list);
	clear_container(remove_view);
	removing_song = FALSE;
	mysongs_refresh_list();
}


void mysongs_cancel_song_delete(ClutterActor *actor)
{
	removing_song = FALSE;
	clear_container(remove_view);
}

void mysongs_remove_song_view(ClutterActor *actor){

	if(removing_song) return;

	removing_song = TRUE;
	remove_view = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-container"));
	ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());

	ClutterActor *text = CLUTTER_ACTOR(clutter_text_new_full(TEXT_CAPTION, "Remove?", &mysongs_text_color));
	clutter_actor_set_position(text, 20, 60);
	clutter_container_add_actor(listContainer, text);
	
	ClutterActor *ok_button = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
		"/opt/jammo/backingtracks/button_ok.png", NULL));

	ClutterActor *cancel_button = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
		"/opt/jammo/backingtracks/button_cancel.png", NULL));

	clutter_actor_set_position(ok_button, 170, 40);
	clutter_container_add_actor(listContainer, ok_button);

	clutter_actor_set_position(cancel_button, 260, 60);
	clutter_container_add_actor(listContainer, cancel_button);

	g_signal_connect_swapped(CLUTTER_ACTOR(ok_button), "clicked", G_CALLBACK(mysongs_delete_song), actor);
	g_signal_connect_swapped(CLUTTER_ACTOR(cancel_button), "clicked", G_CALLBACK(mysongs_cancel_song_delete), remove_view);

	clutter_container_add_actor(remove_view, CLUTTER_ACTOR(listContainer));
}

void mysongs_label_button_clicked(ClutterActor *label){

	currentlyModifiedLabel = label;
	
	start_record_cover_tool(clutter_actor_get_name(label));
}


void mysongs_update_label_button(const gchar* path){

	currentlyModifiedLabel = tangle_button_new_with_background_actor(clutter_rectangle_new_with_color(clutter_color_new(255,255, 255,255)));
	mysongs_refresh_list();
}

void mysongs_refresh_list()
{
	int numberOfLoops = 0;
	GList* l = NULL; //Iterator
	GList* projects = NULL;
	GList* finalized = NULL;

	puts("Refreshing list...");

	clear_container(songlist.list);

	songlist.list = 0;

	projects = file_helper_get_all_files(configure_get_projects_directory()); //Project-files
	finalized = file_helper_get_all_files(configure_get_finalized_directory()); //Audio-files

	numberOfLoops += g_list_length (projects) + g_list_length (finalized);

	if(numberOfLoops > 5)
		songlist.list = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-scrollable"));	

	else	songlist.list = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-unscrollable"));	

	clutter_actor_lower(CLUTTER_ACTOR(songlist.list),jammo_get_actor_by_id("mysongs_down-index"));

	for (l = projects; l; l = l->next)
		mysongs_add_loop_to_list(l->data, 0); //0 = Project-file

	for (l = finalized; l; l = l->next)
		mysongs_add_loop_to_list(l->data, 1); //1 = Finalized file

	if(numberOfLoops <= 6)
		clutter_actor_set_height(CLUTTER_ACTOR(songlist.list), songlist.listItemHeight * numberOfLoops);

	else	clutter_actor_set_height(CLUTTER_ACTOR(songlist.list), songlist.listItemHeight * 6);

	ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(songlist.list), TANGLE_TYPE_SCROLL_ACTION);

	g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(community_autoscroll_to_correct_pos), &songlist);	
}
