#include <tangle.h>
#include <glib-object.h>
#include "gamesmenu.h"
#include "startmenu.h"
#include "../jammo.h"

#include "../jammo-game-task.h"
#include "../jammo-game-level.h"
#include "../jammo-game-level-view.h"


#include "../jammo-mentor.h"
#include "../jammo-editing-track-view.h"
#include "../jammo-miditrack-view.h"
#include "../../cem/cem.h"

#include "sequencer.h"
#include "sequencer_loop.h"
#include "../jammo-chum.h" //jammo_chum_disable_actor and enable

static void demo_for_task1(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer);
static void to_task1(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer);

//Functions for whole level
//This triggers very same time than last task-completed
void level1_completed(JammoGameLevel* game_level) {
	g_print("MENTOR: All task on level1 completed -> Level1 completed\n");
	sequencer_render_button_pressed (NULL, NULL); // test
}

//Used on task1 and task5
//This is assigned on c-file
static void level1_sample_button_on_wheel_listened(JammoSampleButton* sample_button, JammoGameTask* task) {
	gchar* name = g_strdup_printf("%d",jammo_sample_button_get_loop_id(sample_button));
	jammo_game_task_set_act_completed(task,name, TRUE);
	g_free(name);
}

static void add_act_to_this_task(ClutterActor* sample_button, gpointer task){
	int id=jammo_sample_button_get_loop_id(JAMMO_SAMPLE_BUTTON(sample_button));

	gchar* act_name = g_strdup_printf("%d",id);
	//printf("act_name ='%s' \n",act_name);
	jammo_game_task_add_act(task, act_name);
	g_signal_connect(sample_button,"listened", G_CALLBACK(level1_sample_button_on_wheel_listened),task);
	g_free(act_name);
}

static void remove_listened_handler(ClutterActor* sample_button, gpointer task){
	int id=jammo_sample_button_get_loop_id(JAMMO_SAMPLE_BUTTON(sample_button));
	gchar* act_name = g_strdup_printf("%d",id);
	//printf("removing signal-handler for act_name ='%s' \n",act_name);
	g_signal_handlers_disconnect_by_func(sample_button, level1_sample_button_on_wheel_listened, task);
	g_free(act_name);
}

//
static void sample_button_dropped(JammoSampleButton* sample_button, gpointer task) {
	//Same sample-loop can be dragged several times -> we generate act-names when act is done
	// (using timestamp, so them will not collide)
	char time[80];
	cem_get_time(time);
	gchar* name = g_strdup_printf("%d_%s",jammo_sample_button_get_loop_id(sample_button),time);
	jammo_game_task_add_act(task, name);
	jammo_game_task_set_act_completed(task,name, TRUE);
	g_free(name);
	sequencer_change_to_loop_view(NULL,NULL); //automatic transition to loop_view
}
static void add_dropped_listener(ClutterActor* sample_button, gpointer task){
	g_signal_connect(sample_button,"dropped", G_CALLBACK(sample_button_dropped),task);
}
static void remove_dropped_listener(ClutterActor* sample_button, gpointer task){
	g_signal_handlers_disconnect_by_func(sample_button,sample_button_dropped,task);
}

///////////////
//Task specific
///////////////

//Task1: listening four rhythmic loops
void level1_task1_started(JammoGameTask* task) {

	//disable melodical_sample_looper
	//jammo_chum_disable_actor(sequencer_loop_get_nth_sample_looper(2)); //TODO: disabling container should disable elements
	clutter_actor_hide(sequencer_loop_get_nth_sample_looper(2));

	//disable/hide track2 entirely (it will used on task6)
	ClutterActor* track_view2 = jammo_get_actor_by_id("track-view2");
	jammo_chum_disable_actor(track_view2); //FIXME: disabled track looks like enabled track
	ClutterActor* track2_controls = jammo_get_actor_by_id("controls-for-track2-level1");
	jammo_chum_disable_actor(track2_controls); //FIXME: buttons are still reactive etc

	//assign sample-buttons to task
	ClutterActor* rhytmical_sample_looper  = sequencer_loop_get_nth_sample_looper(1);
	clutter_container_foreach(CLUTTER_CONTAINER(rhytmical_sample_looper), add_act_to_this_task, task);

	g_print("MENTOR: Lets_rock.\n");
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "lets_rock.spx",demo_for_task1,NULL);
}

void level1_task1_on_act_completed(JammoGameTask* task, const gchar* act_name, guint acts_completed) {
	gint act_left;

	act_left = (gint)jammo_game_task_get_acts_to_complete(task) - (gint)acts_completed;
	if (act_left > 0) {
		if (act_left > 2 ) {
			jammo_mentor_speak(jammo_mentor_get_default(), "listen_another.spx three.spx rhythmloopB.spx");
		}
		else if (act_left > 1 ) {
			jammo_mentor_speak(jammo_mentor_get_default(), "listen_another.spx two.spx rhythmloopB.spx");
		}
		else
			jammo_mentor_speak(jammo_mentor_get_default(), "listen_another.spx one.spx rhythmloop.spx");
		g_print("MENTOR: Good! Listen %u more loops.\n", act_left);
	}
}

void level1_task1_on_act_redone(JammoGameTask* task, const gchar* task_name, guint tasks_completed) {
	jammo_mentor_speak(jammo_mentor_get_default(), "listen_to_different.spx");
	g_print("MENTOR: You had already listened this loop. Try another!\n");
}

static void task1_finalize(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer){
	jammo_game_level_start_next_task(JAMMO_GAME_LEVEL(jammo_get_object_by_id("game-level")));
}

void level1_task1_completed(JammoGameTask* task) {
	clutter_container_foreach(CLUTTER_CONTAINER(sequencer_loop_get_nth_sample_looper(1)), remove_listened_handler, task);
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "fine_found_rhythms.spx", task1_finalize, NULL);
	g_print("MENTOR: Excellent! Now you have accomplished level1-task1. Please, proceed.\n");
}


static void to_task1(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer){
	jammo_mentor_speak(jammo_mentor_get_default(), "your_turn.spx");
}

static void demo_for_task1(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer sequencer){
	sequencer_change_to_loop_view(NULL,NULL);
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "listen_different.spx rhythmloops.spx", to_task1, NULL);
	g_print("MENTOR demo to task! TODO\n"); //TODO
}



//Task1 over


//Task2 - listen backing track 
static void task2_on_sequencer_stopped(JammoSequencer* sequencer, gpointer user_data){
	g_signal_handlers_disconnect_by_func(sequencer, task2_on_sequencer_stopped, NULL);
	JammoGameTask* task = JAMMO_GAME_TASK(jammo_get_object_by_id("level1-task2.json"));
	jammo_game_task_set_act_completed(task,"backing_track_listened", TRUE);
}

static void to_task2(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer data){
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	g_signal_connect(sequencer, "stopped", G_CALLBACK(task2_on_sequencer_stopped),NULL);
	jammo_sequencer_play(sequencer);
}


void level1_task2_started(JammoGameTask* task) {

	g_print("MENTOR: Listen backing track\n");
	sequencer_change_to_sequencer_view(NULL,NULL);
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "listen_backing_track1.spx", to_task2, NULL);
}

void level1_task2_on_act_completed(JammoGameTask* task, const gchar* act_name, guint acts_completed) {
	g_print("MENTOR: Act completed\n");
	jammo_mentor_speak(jammo_mentor_get_default(), "greatB.spx");
}

void level1_task2_finalize(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer data){
	jammo_game_level_start_next_task(JAMMO_GAME_LEVEL(jammo_get_object_by_id("game-level")));
}

void level1_task2_completed(JammoGameTask* task) {
	g_print("MENTOR: Excellent! Now you have accomplished level1-task2. Please, proceed.\n");
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "", level1_task2_finalize, NULL); //TODO:speach
}
//Task2 over


//Task3 -drop four rhythm loops to track

void level1_task3_started(JammoGameTask* task) {
	sequencer_change_to_loop_view(NULL,NULL);
	clutter_container_foreach(CLUTTER_CONTAINER(sequencer_loop_get_nth_sample_looper(1)), add_dropped_listener, task);
}

void level1_task3_on_act_completed(JammoGameTask* task, const gchar* act_name, guint acts_completed) {
	gint act_left;
	act_left = (gint)jammo_game_task_get_acts_to_complete(task) - (gint)acts_completed;
	g_print("MENTOR: Good! Listen %u more loops.\n", act_left);
}

static void level1_task3_finalize(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer data){
	jammo_game_level_start_next_task(JAMMO_GAME_LEVEL(jammo_get_object_by_id("game-level")));
}

void level1_task3_completed(JammoGameTask* task) {
	g_print("MENTOR: Excellent! Now you have accomplished level1-task3. Please, proceed.\n");
	clutter_container_foreach(CLUTTER_CONTAINER(sequencer_loop_get_nth_sample_looper(1)), remove_dropped_listener, task);
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "", level1_task3_finalize, NULL); //TODO:speach
}


//Task3 over


//Task4 -use play-button
static void task4_on_sequencer_stopped(JammoSequencer* sequencer, gpointer task){
	g_signal_handlers_disconnect_by_func(sequencer, task4_on_sequencer_stopped, NULL);
	jammo_game_task_set_act_completed(task,"play_button_used", TRUE);
}

void level1_task4_started(JammoGameTask* task) {
	printf("level1_task4_started\n");
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	g_signal_connect(sequencer, "stopped", G_CALLBACK(task4_on_sequencer_stopped),task);

	sequencer_change_to_sequencer_view(NULL,NULL);
}

static void level1_task4_finalize(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer data){
	jammo_game_level_start_next_task(JAMMO_GAME_LEVEL(jammo_get_object_by_id("game-level")));
}

void level1_task4_completed(JammoGameTask* task) {
	g_print("MENTOR: Excellent! Now you have accomplished level1-task4. Please, proceed.\n");
	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "", level1_task4_finalize, NULL); //TODO:speach
}

//Task4 over


//Task5 - listen four melodic loops
void level1_task5_started(JammoGameTask* task) {
	sequencer_change_to_loop_view(NULL,NULL);

	//enable melodical_sample_looper
	//jammo_chum_enable_actor(sequencer_loop_get_nth_sample_looper(2)); //TODO: disabling container should disable elements
	clutter_actor_show(sequencer_loop_get_nth_sample_looper(2));

	//assign sample-buttons to task
	ClutterActor* melodical_sample_looper  = sequencer_loop_get_nth_sample_looper(2);
	clutter_container_foreach(CLUTTER_CONTAINER(melodical_sample_looper), add_act_to_this_task, task);

}


//FIXME: This is copy-pasted : level1_task1_on_act_completed
void level1_task5_on_act_completed(JammoGameTask* task, const gchar* act_name, guint acts_completed) {
	gint act_left;

	act_left = (gint)jammo_game_task_get_acts_to_complete(task) - (gint)acts_completed;
	if (act_left > 0) {
		if (act_left > 2 ) {
			jammo_mentor_speak(jammo_mentor_get_default(), "listen_another.spx three.spx rhythmloopB.spx");
		}
		else if (act_left > 1 ) {
			jammo_mentor_speak(jammo_mentor_get_default(), "listen_another.spx two.spx rhythmloopB.spx");
		}
		else
			jammo_mentor_speak(jammo_mentor_get_default(), "listen_another.spx one.spx rhythmloop.spx");
		g_print("MENTOR: Good! Listen %u more loops.\n", act_left);
	}
}

void level1_task5_on_act_redone(JammoGameTask* task, const gchar* task_name, guint tasks_completed) {
	jammo_mentor_speak(jammo_mentor_get_default(), "listen_to_different.spx");
	g_print("MENTOR: You had already listened this loop. Try another!\n");
}

static void level1_task5_finalize(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer data){
	jammo_game_level_start_next_task(JAMMO_GAME_LEVEL(jammo_get_object_by_id("game-level")));
}


void level1_task5_completed(JammoGameTask* task) {
	clutter_container_foreach(CLUTTER_CONTAINER(sequencer_loop_get_nth_sample_looper(2)), remove_listened_handler, task);

	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "fine_found_rhythms.spx", level1_task5_finalize, NULL);
	g_print("MENTOR: Excellent! Now you have accomplished level1-task5. Please, proceed.\n");
}

//Task5 over


//Task6 - -drop four melodic loops to melodic track
//rhythmic loops do not count


/* Sample must be dropped correct track*/
static gboolean on_dropping_incompatible_sample(JammoEditingTrackView* track_view, JammoSampleButton* sample_button, gpointer user_data) {
	g_print("Dropping incompatible sample!\n");
	return FALSE;
}



void level1_task6_started(JammoGameTask* task) {
	//enable track2
	ClutterActor* track_view2 = jammo_get_actor_by_id("track-view2");
	jammo_chum_enable_actor(track_view2);
	ClutterActor* track2_controls = jammo_get_actor_by_id("controls-for-track2-level1");
	jammo_chum_enable_actor(track2_controls);

	sequencer_change_to_loop_view(NULL,NULL);
	clutter_container_foreach(CLUTTER_CONTAINER(sequencer_loop_get_nth_sample_looper(2)), add_dropped_listener, task);

	ClutterActor* track_view = jammo_get_actor_by_id("track-view1");
	g_signal_connect(track_view, "dropping-incompatible-sample", G_CALLBACK(on_dropping_incompatible_sample), NULL);
	g_signal_connect(track_view2, "dropping-incompatible-sample", G_CALLBACK(on_dropping_incompatible_sample), NULL);
}

void level1_task6_on_act_completed(JammoGameTask* task, const gchar* act_name, guint acts_completed) {
	gint act_left;
	act_left = (gint)jammo_game_task_get_acts_to_complete(task) - (gint)acts_completed;
	g_print("MENTOR: Good! Drag %u more loops.\n", act_left);
}


static void level1_task6_finalize(JammoMentor* mentor, const gchar* speech, gboolean interrupted, gpointer data){
	jammo_game_level_start_next_task(JAMMO_GAME_LEVEL(jammo_get_object_by_id("game-level")));
}

void level1_task6_completed(JammoGameTask* task) {
	g_print("MENTOR: Excellent! Now you have accomplished level1-task6. Please, proceed.\n");
	clutter_container_foreach(CLUTTER_CONTAINER(sequencer_loop_get_nth_sample_looper(2)), remove_dropped_listener, task);

	ClutterActor* track_view = jammo_get_actor_by_id("track-view1");
	g_signal_handlers_disconnect_by_func(track_view, G_CALLBACK(on_dropping_incompatible_sample), NULL); //FIXME: this doesn't work

	ClutterActor* track_view2 = jammo_get_actor_by_id("track-view2");
	g_signal_handlers_disconnect_by_func(track_view2, G_CALLBACK(on_dropping_incompatible_sample), NULL); //FIXME: this doesn't work

	jammo_mentor_speak_with_callback(jammo_mentor_get_default(), "", level1_task6_finalize, NULL); //TODO:speach
}

//Task6 over
