/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */
#include <tangle.h>
#include <glib-object.h>
#include "gamesmenu.h"
#include "startmenu.h"
#include "sequencer.h"
#include "../jammo.h"

#include "../jammo-game-task.h"
#include "../jammo-game-level.h"
#include "../jammo-game-level-view.h"

#include "../../cem/cem.h"

/*  TODO: use signal in json
//return to startmenu
static gboolean goto_startmenu(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	clutter_actor_hide(gamesmenu_group);
	show_startmenu();
	return TRUE;
}*/

gboolean start_gamesmenu()
{
	cem_add_to_log("Gamesmenu starting",J_LOG_DEBUG);

	ClutterActor* mainview;

	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

	clutter_actor_show (jammo_get_actor_by_id("fullsequencer-view")); //contains only templates (show works better than load_now() )
	clutter_actor_show (jammo_get_actor_by_id("gamesmenu-view"));

	return FALSE;
}

void gamesmenu_start_first_task_on_this_level(const char* levelname) {
	gchar* message = g_strdup_printf("Starting level: '%s'",levelname);
	cem_add_to_log(message, J_LOG_DEBUG);
	g_free(message);
	
	clutter_actor_hide(jammo_get_actor_by_id("gamesmenu-view"));
	//tangle_view_unload(TANGLE_VIEW(jammo_get_actor_by_id("gamesmenu-view")));

	gchar* view_name = g_strdup_printf("%s-view",levelname);
	ClutterActor* levelview = jammo_get_actor_by_id(view_name);
	g_free(view_name);
	if (levelview==NULL){
		message = g_strdup_printf("levelview '%s' was NULL",view_name);
		cem_add_to_log(message, J_LOG_ERROR);
		g_free(message);
	}


	clutter_actor_set_name(levelview,levelname);
	start_fullsequencer_gui(levelview);

}

/*
name of button should be in format "level1".
*/
void start_level(TangleButton* button,gpointer data) {
	gamesmenu_start_first_task_on_this_level(clutter_actor_get_name(CLUTTER_ACTOR(button)));
}


void all_levels_completed(JammoGameLevel* game_level) {
	g_print("MENTOR: Now you have gone through all game levels! Feel free to do whatever you want now on...\n");
}
