/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */
#include <tangle.h>
#include <glib-object.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"
#include "mysongs.h"
#include "jammosongs.h"
#include "workshops.h"
#include "jammosounds.h"
#include "help.h"
#include "discuss.h"
#include "avatar_editor.h"

gboolean start_communitymenu()
{
	puts("Starting communitymenu\n");

	ClutterActor* mainview;

	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);


	ClutterActor* communitymenu_view = jammo_get_actor_by_id("communitymenu-view");
	if (communitymenu_view){
		clutter_actor_show (CLUTTER_ACTOR(communitymenu_view));
		
		
		//show available buttons depending on the game level
		tangle_actor_show(TANGLE_ACTOR(jammo_get_actor_by_id("communitymenu_goto_profile")));
		tangle_actor_show(TANGLE_ACTOR(jammo_get_actor_by_id("communitymenu_goto_mysongs")));
		tangle_actor_show(TANGLE_ACTOR(jammo_get_actor_by_id("communitymenu_goto_jammosongs")));		
		tangle_actor_show(TANGLE_ACTOR(jammo_get_actor_by_id("communitymenu_goto_workshops")));
		tangle_actor_show(TANGLE_ACTOR(jammo_get_actor_by_id("communitymenu_goto_jammosounds")));
		tangle_actor_show(TANGLE_ACTOR(jammo_get_actor_by_id("communitymenu_goto_help")));
		tangle_actor_show(TANGLE_ACTOR(jammo_get_actor_by_id("communitymenu_goto_discuss")));
		
		
	}else
		puts("can't find 'communitymenu-view' \n");
             
		
	return FALSE;
}

void communitymenu_goto_mysongs(TangleButton* tanglebutton, gpointer none){

	puts("communitymenu_goto_mysongs");
	
	start_mysongs();

}

void communitymenu_goto_jammosongs(TangleButton* tanglebutton, gpointer none){

	puts("communitymenu_goto_jammosongs");
	
	start_jammosongs();

}

void communitymenu_goto_workshops(TangleButton* tanglebutton, gpointer none){
	
	puts("communitymenu_goto_workshops");
	
	start_workshops(); 

}


void communitymenu_goto_jammosounds(TangleButton* tanglebutton, gpointer none){
	
	puts("communitymenu_goto_jammosounds");
	
	start_jammosounds(); 

}


void communitymenu_goto_help(TangleButton* tanglebutton, gpointer none){
	
	puts("communitymenu_goto_helpdesk");
	
	start_helpdesk(); 

}


void communitymenu_goto_discuss(TangleButton* tanglebutton, gpointer none){
	
	puts("communitymenu_goto_discuss");
	
	start_discuss(); 

}

void communitymenu_goto_profile(TangleButton* tanglebutton, gpointer none){
	
	puts("communitymenu_goto_profile");
	
	start_avatar_editor(); 

}



