/** cem.c is part of JamMo.
License: GPLv2, read more from COPYING

(from D2.4)
CEM is started as JamMo is started as it is used to log user actions in
all use cases. Mentor and games components only need to be started if
the use case is correct.
*/
#include <stdio.h>
#include "cem.h"
#include <glib.h>


#include "../configure.h"

static int log_level=J_LOG_NONE; //Default.
static FILE *log_file = NULL;

void cem_set_log_level(int new_level) {
	log_level=new_level;
	gchar* message = g_strdup_printf("Setting logging level to %d ",new_level);
	cem_add_to_log(message,J_LOG_DEBUG);
	g_free(message);
}

void cem_append_to_log_level(int level){
	int old_log_level = log_level;
	if (!(level & log_level)) //Not yet, so add
		log_level+=level;

	gchar* message = g_strdup_printf("Add '%d' to log_level %d. New log_level: %d \n",level, old_log_level, log_level);
	cem_add_to_log(message,J_LOG_DEBUG);
	g_free(message);
}


static gchar* type_to_word(int type) {
GString* string = g_string_new("");

if (type & J_LOG_DEBUG)
	string = g_string_append(string,"DEBUG ");
if (type & J_LOG_INFO)
	string = g_string_append(string,"INFO ");
if (type & J_LOG_FATAL)
	string = g_string_append(string,"FATAL ");
if (type & J_LOG_ERROR)
	string = g_string_append(string,"ERROR ");
if (type & J_LOG_WARN)
	string = g_string_append(string,"WARN ");
if (type & J_LOG_USER_ACTION)
	string = g_string_append(string,"USER ");
if (type & J_LOG_NETWORK)
	string = g_string_append(string,"NETWORK ");
if (type & J_LOG_NETWORK_DEBUG)
	string = g_string_append(string,"NETWORK_DEBUG ");

return g_string_free (string, FALSE);
}


void cem_get_time(char timestamp_now[]) {
	time_t rawtime;
	struct tm * timeinfo;
	time ( &rawtime );
	timeinfo = localtime ( &rawtime );
	strftime (timestamp_now,80,"%Y.%m.%d_%H.%M.%S",timeinfo);
}

/*
No need to add linebreaks.
Usage:
cem_add_to_log("error_message",J_LOG_ERROR);
or
cem_add_to_log("fatal+info_message",J_LOG_FATAL+J_LOG_INFO);
*/
void cem_add_to_log(char *message,int type){
	gchar* name;
	char timestamp [80];
	cem_get_time(timestamp);

	//Initialize if NULL
	if (log_file==NULL){
		gchar* jammo_directory=configure_get_jammo_directory();
		gchar* outputFilename = g_strdup_printf("%s/%s.log",jammo_directory,timestamp);
		g_free(jammo_directory);

		log_file = fopen(outputFilename, "a");
		if (log_file==NULL)
			printf("ERROR starting logging to file '%s'\n",outputFilename);
		else {
			//This will be very first row on log file (if first cem_add_to_log-call is set_log_level)
			gchar* msg = g_strdup_printf("Log started on file: '%s' ",outputFilename);
			cem_add_to_log(msg,J_LOG_INFO);
			g_free(msg);
		}

		g_free(outputFilename);
	}

	if (type & log_level) { //We are interested in this type of log-message
		name=type_to_word(type);
		gchar* final = g_strdup_printf("*%s %s: '%s' :%s*\n",timestamp, name,message,name);

		if (log_file) {
			fprintf(log_file,"%s",final);
			fflush(log_file);
		}
		//else  //Currently we want them to STDOUT too
			printf("%s",final);

		g_free(name);
		g_free(final);
	}

}

void jammo_cem_cleanup() {
cem_add_to_log("Stopping logging",J_LOG_DEBUG);
if (log_file)
	fclose(log_file);
}
