
#include <meam/jammo-meam.h>
#include <meam/jammo-sequencer.h>
#include <meam/jammo-editing-track.h>

JammoEditingTrack* editing_track;
JammoSample *sample3;

static gboolean cb(gpointer user_data) {
	JammoSequencer* sequencer;

	sequencer = JAMMO_SEQUENCER(user_data);

	jammo_sequencer_stop(sequencer);
	jammo_editing_track_remove_sample(editing_track, sample3);
	jammo_sequencer_play(sequencer);
	//jammo_sequencer_set_position(sequencer, 10000000000LLU);

	return FALSE;
}

int main(int argc, char** argv) {
	GMainLoop* main_loop;
	JammoSequencer* sequencer;
	JammoSample * sample1, *sample2;
	
	jammo_meam_init(&argc, &argv, "jammo_test_duration_cache");
	main_loop = g_main_loop_new (NULL, FALSE);

	sequencer = jammo_sequencer_new();


	editing_track = jammo_editing_track_new();
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(editing_track));
	jammo_sequencer_set_pitch(sequencer, "A");
	jammo_sequencer_set_tempo(sequencer, 130);
	sample1=jammo_sample_new_from_file("/opt/jammo/wheel_game/Me_FolkMetalAccordion1_$t_$p_44_2.ogg");
	sample2=jammo_sample_new_from_file("/opt/jammo/wheel_game/Me_strings05_$t_$p_44_2.ogg");
	sample3=jammo_sample_new_from_file("/opt/jammo/wheel_game/Me_flute13_$t_$p_44_2.ogg");
	jammo_editing_track_add_sample(editing_track, sample1, 0);
	jammo_editing_track_add_sample(editing_track, sample2, 7000000000LLU);
	jammo_editing_track_add_sample(editing_track, sample3, 14000000000LLU);

	g_print("Playing...\n");

	jammo_sequencer_play(JAMMO_SEQUENCER(sequencer));

	g_timeout_add(15000, cb, sequencer);

	g_main_loop_run(main_loop);

	return 0;
}
