#include "slider_helper.h"

/**
This file contains generated table for changing X-coordinates for slider
frequency and back.
*/
#if 0
//This is code for generating table.

//gcc `pkg-config --libs --cflags glib-2.0` -lm
#include <stdio.h>
#include <glib.h>
#include <math.h>

//These values should be same than in instrument_gui.c
//For slider
#define RANGE 2.0
// X coordinates of playing area
#define RIGHT_X 599.0
#define LEFT_X 0.0
#define OCTAVE_ON_SCREEN ((RIGHT_X - LEFT_X)/RANGE)
#define BASE_FREQUENCY 130.81

static void generate_table() {
	// X-coordinate to freq (int -> float)
	printf("/*Generated with values: RANGE %f\n RIGHT_X %f\n LEFT_X %f\n OCTAVE_ON_SCREEN %f\n BASE_FREQUENCY %f\n*/\n", RANGE,RIGHT_X,LEFT_X,OCTAVE_ON_SCREEN,BASE_FREQUENCY);
	printf("static float freq_table[] = {\n");
	int i;
	gfloat freq;
	for (i=LEFT_X;i<RIGHT_X;i++){
		freq = BASE_FREQUENCY*pow(2.0, i/OCTAVE_ON_SCREEN);
		printf("%10f, ", freq);
		if (i%7==0)
			printf("\n");
	}
	freq = BASE_FREQUENCY*pow(2.0, RIGHT_X/OCTAVE_ON_SCREEN);
	printf("%f };\n ", freq);
}
int main (int argc, char **argv) {
	generate_table();
	return 0;
}
#endif


/*Generated with values: RANGE 2.000000
 RIGHT_X 599.000000
 LEFT_X 0.000000
 OCTAVE_ON_SCREEN 299.500000
 BASE_FREQUENCY 130.810000
*/
static float freq_table[] = {
130.809998, 
131.113083, 131.416885, 131.721375, 132.026581, 132.332489, 132.639114, 132.946442, 
133.254471, 133.563232, 133.872696, 134.182892, 134.493790, 134.805420, 135.117767, 
135.430847, 135.744644, 136.059158, 136.374420, 136.690399, 137.007111, 137.324570, 
137.642746, 137.961670, 138.281326, 138.601730, 138.922882, 139.244766, 139.567398, 
139.890778, 140.214905, 140.539795, 140.865433, 141.191818, 141.518967, 141.846863, 
142.175522, 142.504959, 142.835144, 143.166092, 143.497818, 143.830307, 144.163559, 
144.497589, 144.832397, 145.167984, 145.504333, 145.841476, 146.179398, 146.518097, 
146.857574, 147.197861, 147.538910, 147.880768, 148.223404, 148.566849, 148.911087, 
149.256119, 149.601944, 149.948578, 150.296005, 150.644257, 150.993301, 151.343155, 
151.693817, 152.045303, 152.397598, 152.750702, 153.104630, 153.459381, 153.814941, 
154.171341, 154.528564, 154.886612, 155.245483, 155.605194, 155.965729, 156.327118, 
156.689331, 157.052383, 157.416275, 157.781006, 158.146591, 158.513031, 158.880310, 
159.248428, 159.617416, 159.987259, 160.357956, 160.729507, 161.101913, 161.475189, 
161.849335, 162.224350, 162.600220, 162.976974, 163.354599, 163.733093, 164.112473, 
164.492722, 164.873856, 165.255875, 165.638779, 166.022568, 166.407242, 166.792816, 
167.179276, 167.566635, 167.954895, 168.344055, 168.734116, 169.125076, 169.516937, 
169.909714, 170.303406, 170.697998, 171.093506, 171.489929, 171.887283, 172.285553, 
172.684738, 173.084854, 173.485901, 173.887878, 174.290771, 174.694611, 175.099380, 
175.505096, 175.911743, 176.319336, 176.727875, 177.137360, 177.547791, 177.959167, 
178.371506, 178.784805, 179.199051, 179.614258, 180.030426, 180.447571, 180.865662, 
181.284744, 181.704773, 182.125793, 182.547791, 182.970749, 183.394699, 183.819626, 
184.245544, 184.672455, 185.100342, 185.529221, 185.959106, 186.389969, 186.821838, 
187.254715, 187.688583, 188.123474, 188.559357, 188.996262, 189.434158, 189.873093, 
190.313034, 190.753983, 191.195969, 191.638977, 192.083008, 192.528076, 192.974167, 
193.421295, 193.869461, 194.318649, 194.768906, 195.220184, 195.672516, 196.125885, 
196.580322, 197.035797, 197.492340, 197.949936, 198.408585, 198.868317, 199.329086, 
199.790939, 200.253860, 200.717865, 201.182922, 201.649078, 202.116302, 202.584610, 
203.054001, 203.524490, 203.996063, 204.468719, 204.942490, 205.417343, 205.893295, 
206.370361, 206.848526, 207.327805, 207.808182, 208.289688, 208.772293, 209.256027, 
209.740875, 210.226852, 210.713959, 211.202179, 211.691544, 212.182037, 212.673676, 
213.166443, 213.660355, 214.155411, 214.651611, 215.148972, 215.647476, 216.147141, 
216.647964, 217.149933, 217.653076, 218.157394, 218.662857, 219.169510, 219.677338, 
220.186325, 220.696518, 221.207870, 221.720413, 222.234146, 222.749069, 223.265182, 
223.782501, 224.301010, 224.820724, 225.341629, 225.863754, 226.387085, 226.911636, 
227.437393, 227.964371, 228.492569, 229.022003, 229.552643, 230.084534, 230.617645, 
231.151993, 231.687576, 232.224396, 232.762466, 233.301788, 233.842361, 234.384171, 
234.927246, 235.471588, 236.017181, 236.564041, 237.112167, 237.661560, 238.212219, 
238.764175, 239.317398, 239.871902, 240.427689, 240.984772, 241.543137, 242.102798, 
242.663757, 243.226013, 243.789581, 244.354446, 244.920624, 245.488113, 246.056915, 
246.627029, 247.198471, 247.771240, 248.345337, 248.920761, 249.497513, 250.075607, 
250.655029, 251.235809, 251.817932, 252.401398, 252.986221, 253.572403, 254.159927, 
254.748825, 255.339081, 255.930710, 256.523712, 257.118073, 257.713837, 258.310974, 
258.909485, 259.509369, 260.110657, 260.713348, 261.317444, 261.922913, 262.529785, 
263.138092, 263.747772, 264.358887, 264.971436, 265.585358, 266.200745, 266.817535, 
267.435760, 268.055420, 268.676514, 269.299042, 269.923004, 270.548431, 271.175293, 
271.803619, 272.433380, 273.064636, 273.697327, 274.331482, 274.967133, 275.604218, 
276.242828, 276.882874, 277.524414, 278.167450, 278.811981, 279.457977, 280.105499, 
280.754517, 281.405029, 282.057068, 282.710602, 283.365631, 284.022217, 284.680298, 
285.339905, 286.001038, 286.663727, 287.327911, 287.993683, 288.660950, 289.329803, 
290.000183, 290.672119, 291.345612, 292.020660, 292.697296, 293.375488, 294.055237, 
294.736572, 295.419495, 296.103973, 296.790070, 297.477722, 298.166992, 298.857849, 
299.550323, 300.244385, 300.940063, 301.637360, 302.336243, 303.036774, 303.738922, 
304.442688, 305.148102, 305.855133, 306.563812, 307.274109, 307.986084, 308.699707, 
309.414948, 310.131897, 310.850464, 311.570709, 312.292633, 313.016235, 313.741486, 
314.468445, 315.197083, 315.927399, 316.659393, 317.393127, 318.128510, 318.865631, 
319.604462, 320.345001, 321.087250, 321.831207, 322.576904, 323.324310, 324.073456, 
324.824341, 325.576996, 326.331360, 327.087463, 327.845337, 328.604980, 329.366364, 
330.129517, 330.894440, 331.661133, 332.429596, 333.199829, 333.971863, 334.745697, 
335.521301, 336.298706, 337.077942, 337.858948, 338.641785, 339.426422, 340.212891, 
341.001160, 341.791290, 342.583221, 343.376984, 344.172607, 344.970062, 345.769379, 
346.570526, 347.373535, 348.178406, 348.985138, 349.793762, 350.604248, 351.416595, 
352.230835, 353.046967, 353.864990, 354.684906, 355.506714, 356.330444, 357.156067, 
357.983612, 358.813080, 359.644440, 360.477753, 361.312988, 362.150177, 362.989288, 
363.830322, 364.673340, 365.518280, 366.365204, 367.214081, 368.064941, 368.917755, 
369.772552, 370.629303, 371.488068, 372.348816, 373.211578, 374.076294, 374.943054, 
375.811798, 376.682587, 377.555359, 378.430176, 379.307007, 380.185852, 381.066772, 
381.949707, 382.834686, 383.721741, 384.610840, 385.501984, 386.395203, 387.290497, 
388.187866, 389.087280, 389.988831, 390.892426, 391.798157, 392.705963, 393.615875, 
394.527893, 395.442017, 396.358276, 397.276642, 398.197144, 399.119781, 400.044556, 
400.971466, 401.900513, 402.831726, 403.765106, 404.700653, 405.638336, 406.578217, 
407.520264, 408.464508, 409.410919, 410.359558, 411.310364, 412.263367, 413.218597, 
414.176056, 415.135712, 416.097595, 417.061707, 418.028046, 418.996613, 419.967438, 
420.940521, 421.915863, 422.893433, 423.873291, 424.855438, 425.839844, 426.826508, 
427.815491, 428.806732, 429.800293, 430.796173, 431.794312, 432.794800, 433.797607, 
434.802734, 435.810181, 436.819946, 437.832092, 438.846558, 439.863373, 440.882538, 
441.904083, 442.927979, 443.954254, 444.982910, 446.013947, 447.047394, 448.083221, 
449.121429, 450.162048, 451.205078, 452.250549, 453.298431, 454.348724, 455.401459, 
456.456635, 457.514282, 458.574341, 459.636871, 460.701874, 461.769318, 462.839264, 
463.911682, 464.986572, 466.063965, 467.143829, 468.226227, 469.311127, 470.398529, 
471.488434, 472.580902, 473.675873, 474.773407, 475.873474, 476.976074, 478.081238, 
479.188965, 480.299255, 481.412140, 482.527588, 483.645599, 484.766235, 485.889435, 
487.015259, 488.143707, 489.274750, 490.408386, 491.544678, 492.683624, 493.825165, 
494.969391, 496.116241, 497.265747, 498.417938, 499.572784, 500.730316, 501.890503, 
503.053406, 504.218994, 505.387268, 506.558289, 507.731995, 508.908417, 510.087585, 
511.269470, 512.454102, 513.641479, 514.831604, 516.024475, 517.220093, 518.418518, 
519.619690, 520.823669, 522.030457, 523.239990 };

int freq_to_coordinate(gfloat asked_freq){
	int min = LEFT_X;
	int max = RIGHT_X;
	int mid = min + ((max-min)/2);
	//printf("asked_freq %f \n",asked_freq);

	while  ((asked_freq != freq_table[mid]) && min < max) {
		if (asked_freq > freq_table[mid]) {
			min = mid +1;
			}
		else {
			max = mid -1;
		}
	mid = min + ((max-min)/2);
	}
	//Most of the time we are looking value NOT in table.
	//So check which one is closer
	gfloat delta  =freq_table[mid]-asked_freq;    //this is delta of parameter and bigger value from table
	gfloat delta2 =asked_freq-freq_table[mid-1];  //this is delta of parameter and smaller value from table
		return delta<delta2?mid:mid-1; //return index, which is nearer to parameter
}

float coordinate_to_freq(gint asked_coordinate) {
 return freq_table[asked_coordinate];
}
