/*
 * playlist_screen.c
 *
 *  Created on: 2009-10-12
 *      Author: marcin
 */
#include <hildon/hildon.h>
#include "playlist_screen.h"
#include "jamendo_api.h"
#include "track_listview.h"
#include "player.h"

GtkWidget* playlist_screen_new(GList* track_list, const gchar* title) {
	GtkWidget* win;
	GtkWidget *treeview;
	GtkWidget* track_box;

	/* Create the main window */
	win = hildon_stackable_window_new();
	gtk_window_set_title(GTK_WINDOW(win), title);
	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(win),1);
	gtk_widget_show(win);
	while(gtk_events_pending()) gtk_main_iteration();

	player_set_track_list(track_list);
	treeview = track_listview_create(track_list, TRACK_LISTVIEW_NAME|TRACK_LISTVIEW_ARTIST);
	// track list not freed automatically as player uses it
	//g_signal_connect_swapped(G_OBJECT(treeview), "destroy", G_CALLBACK(track_list_free), track_list);

	track_box = hildon_pannable_area_new();
	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(track_box), treeview);
	gtk_container_add(GTK_CONTAINER(win), track_box);

	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(win),0);

	hildon_program_add_window(hildon_program_get_instance(),HILDON_WINDOW(win));

	gtk_widget_show(player_toolbar_create());

	return win;
}
