/*
 * home_screen.c
 *
 *  Created on: 2009-10-02
 *      Author: marcin
 */

#include <hildon/hildon.h>
#include "jamendo_api.h"
#include "album_listview.h"
#include "album_screen.h"
#include "search_screen.h"
#include "playlist_screen.h"
#include "radioselector_screen.h"
#include "playlistselector_screen.h"
#include "player.h"
#include "resource_utils.h"

static void show_search_screen(GtkWidget* button, gpointer data);
static void show_top_100_screen(GtkWidget* button, gpointer data);
static void show_radioselector_screen(GtkWidget* button, gpointer data);
static void show_playlistselector_screen(GtkWidget* button, gpointer data);

/****************************************************************************
 * button menu functions
 *
 * creates buttons for main menu
 ****************************************************************************/

typedef struct {
	const gchar* image;
	const gchar* label;
	GCallback on_click;
} MenuItem;

static MenuItem button_menu_data[] = {
		{ "list_search.png", "Search", G_CALLBACK(show_search_screen) },
		{ "list_star.png", "Favorites", NULL },
		{ "list_radio.png", "Radio", G_CALLBACK(show_radioselector_screen) },
//		{ "list_playlist.png", "Playlists", G_CALLBACK(show_playlistselector_screen) },
		{ "list_top.png", "Most listened", G_CALLBACK(show_top_100_screen) }
};

static GtkWidget* button_menu() {
	GtkWidget* menu_box;
	gint i = 0;

	menu_box = gtk_vbox_new(TRUE, 0);

	GtkWidget* logo = resource_get_image("logo.png");

	gtk_box_pack_start(GTK_BOX(menu_box), logo, TRUE, FALSE, 0);

	for (i = 0; i < G_N_ELEMENTS(button_menu_data); i++) {
		if(i==1)continue;
		GtkWidget* image = resource_get_image(button_menu_data[i].image);

		HildonButton* button = HILDON_BUTTON(hildon_button_new(
						HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
						HILDON_BUTTON_ARRANGEMENT_VERTICAL));

		hildon_button_set_alignment(button, 0, 0.5, 0, 0);
		hildon_button_set_image(button, image);
		hildon_button_set_title(button, button_menu_data[i].label);

		gtk_box_pack_start(GTK_BOX(menu_box), GTK_WIDGET(button), TRUE, FALSE, 0);
		if (button_menu_data[i].on_click)
			g_signal_connect(button, "clicked", button_menu_data[i].on_click, NULL);
	}

	return menu_box;
}

typedef struct {
	GtkWidget *win;
	GtkWidget *listview;
} PopulateAlbumListParam;

static guint populate_album_list(PopulateAlbumListParam *param) {
	GList* album_list;

	album_list = jamendo_get_popular_albums_week();
	album_listview_update_model(param->listview, album_list);
	album_list_free(album_list);

	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(param->win),0);
	gtk_widget_show_all(param->win);

	g_free(param);
	return FALSE;
}

/****************************************************************************
 *
 */
GtkWidget* home_screen_new() {
	GtkWidget* win;
	GtkWidget *table;
	GtkWidget* pannable_area;
	GtkWidget *menu;
	GtkWidget *treeview;

	win = hildon_stackable_window_new();

	table = gtk_table_new(1, 2, TRUE);
	gtk_container_add(GTK_CONTAINER(win), table);

	menu = button_menu();
	gtk_table_attach_defaults(GTK_TABLE(table), menu, 0, 1, 0, 1);

	pannable_area = hildon_pannable_area_new();
	treeview = album_listview_create(NULL);

	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(pannable_area), treeview);
	gtk_table_attach_defaults(GTK_TABLE(table), pannable_area, 1, 2, 0, 1);

	hildon_gtk_window_set_progress_indicator(GTK_WINDOW(win),1);
	hildon_banner_show_information(win,NULL,"Downloading");

	PopulateAlbumListParam* param = g_new0(PopulateAlbumListParam,1);
	param->win = win;
	param->listview = treeview;
	gdk_threads_add_idle((GSourceFunc)populate_album_list, param);

	hildon_program_add_window(hildon_program_get_instance(), HILDON_WINDOW(win));

	gtk_widget_hide(player_toolbar_create());

	return win;
}

static void show_search_screen(GtkWidget* button, gpointer data) {
	GtkWidget* win = search_screen_new();
	gtk_widget_show_all(win);
}

static void show_top_100_screen(GtkWidget* button, gpointer data) {
	GList* track_list = jamendo_get_top_100();
	GtkWidget* win = playlist_screen_new(track_list,"Top 100 Most Listened");
	gtk_widget_show_all(win);
}

static void show_radioselector_screen(GtkWidget* button, gpointer data) {
	GtkWidget* win = radioselector_screen_new();
	gtk_widget_show_all(win);
}

static void show_playlistselector_screen(GtkWidget* button, gpointer data) {
	GtkWidget* win = playlistselector_screen_new();
	gtk_widget_show_all(win);
}
