#include "qdbusmessage.h"

QDBusMessage::QDBusMessage()
{
}

QDBusMessage::QDBusMessage(const QString &service,
                            const QString &path,
                            const QString &interface,
                            const QString &method)
    : m_service(service)
    , m_path(path)
    , m_interface(interface)
    , m_method(method)
{
}

QDBusMessage::QDBusMessage(const QDBusMessage &msg)
    : m_service(msg.m_service)
    , m_path(msg.m_path)
    , m_interface(msg.m_interface)
    , m_method(msg.m_method)
    , m_arguments(msg.m_arguments)
{
}

QDBusMessage QDBusMessage::createMethodCall(const QString &service,
                                             const QString &path,
                                             const QString &interface,
                                             const QString &method)
{
    return QDBusMessage(service, path, interface, method);
}

QDBusMessage &QDBusMessage::operator<<(const QVariant arg)
{
    m_arguments.append(arg);
    return *this;
}

QString QDBusMessage::service()
{
    return m_service;
}

QString QDBusMessage::path()
{
    return m_path;
}

QString QDBusMessage::interface()
{
    return m_interface;
}

QString QDBusMessage::member()
{
    return m_method;
}

QVector<QVariant> &QDBusMessage::arguments()
{
    return m_arguments;
}

