#ifndef _REMOTETABLE_H_
#define _REMOTETABLE_H_

#include <QTableWidget>
#include <QMap>
#include <QString>

class QResizeEvent;
class Remote;
class QWidget;

class RemoteTable : public QTableWidget
{
public:
    RemoteTable(QWidget *parent = 0);
    ~RemoteTable();

    void addItem(Remote *remote);
    void removeAllRows();
    Remote *selected();

protected:
    void resizeEvent(QResizeEvent *);

private:
    QMap<int, Remote*> remotes;
    QWidget *selectRatingWidget(int rating);
};

#endif // _REMOTETABLE_H_

