#include <QSettings>
#include "ut_remotelistwidgetitem.h"
#include <QtTest>
#include "remotelistwidgetitem.h"
#include "remote.h"

void Ut_RemoteListWidgetItem::initTestCase()
{
    subject = NULL;
}

void Ut_RemoteListWidgetItem::cleanupTestCase()
{
}

void Ut_RemoteListWidgetItem::init()
{
    Remote* remote = new Remote("testname", "testmfg", 1, 2);
    subject = new RemoteListWidgetItem(remote);
}

void Ut_RemoteListWidgetItem::cleanup()
{
    if (subject != NULL) {
        delete subject->remote();
        delete subject;
        subject = NULL;
    }
}

void Ut_RemoteListWidgetItem::testData()
{
    QCOMPARE(subject->data(0).toString(), QString("testname (1)"));
    for (int i = 1; i < 16; ++i)
    {
        QCOMPARE(subject->data(i), QVariant());
    }
}

QTEST_MAIN(Ut_RemoteListWidgetItem)


