#include <QResizeEvent>
#include <QHeaderView>
#include "settingstable.h"

SettingsTable::SettingsTable(QWidget *parent)
    : QTableWidget(0, 2, parent) // Always two columns. Key and value.
{
    verticalHeader()->setVisible(false);
    horizontalHeader()->setVisible(false);
}

SettingsTable::~SettingsTable()
{
}

void SettingsTable::appendRow(const QString &key, const QString &value)
{
    int currentRow = rowCount(); 
    QTableWidgetItem *k = new QTableWidgetItem(key);
    QTableWidgetItem *v = new QTableWidgetItem(value);
    k->setFlags(Qt::NoItemFlags | Qt::ItemIsEnabled);
    v->setFlags(Qt::ItemIsEnabled | Qt::ItemIsEditable);
    insertRow(currentRow);
    setItem(currentRow, 0, k);
    setItem(currentRow, 1, v);
    verticalHeader()->resizeSection(currentRow, 60);
}

void SettingsTable::removeAllRows()
{
    clear();
    setRowCount(0);
}

void SettingsTable::resizeEvent(QResizeEvent *e)
{
    setColumnWidth(0, (e->size().width() / 3) - 10);
    setColumnWidth(1, (2 * e->size().width() / 3) - 10);
}

QString SettingsTable::key(unsigned int row) const
{
    return item(row, 0)->text();
}

QString SettingsTable::value(unsigned int row) const
{
    return item(row, 1)->text();
}

