#ifndef SETTINGSDLG_H
#define SETTINGSDLG_H

#include <QDialog>
#include <QSettings>
#include <QNetworkConfigurationManager>

#include "remote.h"

class QWidget;
class QHBoxLayout;
class QVBoxLayout;
class QPushButton;
class QLabel;
class Remote;

class SettingsDlg : public QDialog
{
    Q_OBJECT
public:
    SettingsDlg(QWidget *parent = 0);
    ~SettingsDlg();
    void showEvent(class QShowEvent *);

private slots:
    void showAdvSettingsDlg();
    void showSelectRemoteDlg();
    void showAboutDlg();
    void setRemote(Remote);
    void updateRemoteInfo();
    void rateUpClicked();
    void rateDownClicked();
    void onNetworkStatusUpdate();

private:
    void enableRateBtns(bool enable = true);
    void processRatingSent();
    void setBusy(bool busy = true);

private:
    bool m_busy;
    Remote m_remote;

    QVBoxLayout *m_layout;
    QHBoxLayout *m_btnLayout;
    QHBoxLayout *m_remoteNameLayout;
    QPushButton *m_advSettingsBtn;
    QPushButton *m_selectRemoteBtn;
    QPushButton *m_rateUpBtn;
    QPushButton *m_rateDownBtn;
    QPushButton *m_aboutBtn;
    QLabel *m_remoteNameLabel;
    QLabel *m_ratingLabel;
    QTM_PREPEND_NAMESPACE(QNetworkConfigurationManager) *m_netConfMan;
};

#endif

