#ifndef SELECTREMOTEDLG_H
#define SELECTREMOTEDLG_H

#include <QDialog>
#include <QString>
#include <QMap>

#include "remotedb.h"
#include "remotedbmgr.h"

class QHBoxLayout;
class QListWidget;
class QListWidgetItem;
class RemoteTable;
class QSettings;
class QNetworkAccessManager;
class QNetworkReply;
class QWidget;
class QPushButton;
class QLabel;
class QShowEvent;
class OnlinePollerThread;

class SelectRemoteDlg : public QDialog
{
    Q_OBJECT

public:
    SelectRemoteDlg(QWidget *parent = 0);
    ~SelectRemoteDlg();

public slots:
    void refreshDB();
    void getDB();

private slots:
    void alphabetItemChanged(QListWidgetItem *current,
                             QListWidgetItem *previous);
    void mfgItemChanged(QListWidgetItem *current, QListWidgetItem *previous);
    void downloadRemote();
    void setDB(RemoteDB *db);

signals:
    void remoteChanged(Remote);

protected slots:
    void showEvent(QShowEvent*);

private:
    RemoteDBMgr remoteDBMgr;

    QLabel *remoteNameLabel;
    QHBoxLayout *layout;
    QListWidget *alphabetList;
    QListWidget *mfgList;
    RemoteTable *modelList;
    QPushButton *downloadBtn;
    RemoteDB *remoteDB;
    OnlinePollerThread *onlinePollerThread;

    void setBusy(bool busy = true);
};

#endif

