#include <cstdlib>

#ifdef LIRC_USEQTSOCKET
#include <QTcpSocket>
#include <QHostAddress>
#else
#include <sys/socket.h>
#include <unistd.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#endif

#include <QSettings>
#include <QByteArray>
#include <QString>
#include <QDebug>

#include "irctrl.h"

IrCtrl::IrCtrl(QObject *parent)
    : QObject(parent)
{
    QSettings settings;
    m_killLircTimer.setInterval(
            settings.value("idleTimeout", "300").toInt() * 1000);
    m_killLircTimer.setSingleShot(true);
    connect(&m_killLircTimer, SIGNAL(timeout()),
            this, SLOT(stopLirc()));
    startLirc();
    m_killLircTimer.start();
}
    
IrCtrl::~IrCtrl()
{
}

void IrCtrl::sendCmd(const QString &cmd)
{
    if (!m_killLircTimer.isActive()) {
        startLirc();
    } else {
        m_killLircTimer.stop();
    }

    QSettings settings;
    // Integer demotion. QVariant has no support for unsigned short
    unsigned short lircPort = (unsigned short)
        settings.value("lircPort", LIRC_PORT).toInt();
    QString remoteName = settings.value("remoteName", "").toString();
    QString cmdStr = "SEND_ONCE " + remoteName + " " + cmd + "\n";
    QByteArray buf = cmdStr.toAscii();

#ifdef LIRC_USEQTSOCKET
    QTcpSocket sock;
    sock.setSocketOption(QAbstractSocket::LowDelayOption, 1);
    sock.connectToHost(QHostAddress::LocalHost, lircPort,
            QIODevice::WriteOnly | QIODevice::Unbuffered);
    sock.waitForConnected();
    sock.write(buf);
    sock.waitForBytesWritten();
    sock.close();
#else
    sockaddr_in addr;
    memset(&addr, 0, sizeof(addr));
    addr.sin_family      = AF_INET;
    addr.sin_addr.s_addr = htonl(INADDR_LOOPBACK);
    addr.sin_port        = htons(lircPort);
    int sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (sock == -1) {
        qDebug() << "Socket open fail";
    } else {
        int c = ::connect(sock, (sockaddr*)&addr, sizeof(sockaddr_in));
        if (c == 0) {
            write(sock, buf.constData(), buf.count());
        } else {
            qDebug() << "Connect fail";
        }
        shutdown(sock, SHUT_RDWR);
        close(sock);
    }
#endif

    m_killLircTimer.start();
}

void IrCtrl::stopLirc()
{
    std::system("sudo /etc/init.d/lirc stop");
}

void IrCtrl::startLirc()
{
    std::system("sudo /etc/init.d/lirc start");
}


