#include "ut_settingstable.h"

#define private public
#define protected public
#include "settingstable.h"
#undef private
#undef protected

#include <QDebug>
#include <QHeaderView>

/** test functions() */


void Ut_SettingsTable::testAppendRow()
{
    SettingsTable subject;

    subject.appendRow(QString("testKey1"), QString("testValue1"));
    subject.appendRow(QString("testKey2"), QString("testValue2"));
    subject.appendRow(QString("testKey3"), QString("testValue3"));

    QCOMPARE(subject.rowCount(), 3);
    QCOMPARE(subject.item(0,0)->text(), QString("testKey1"));
    QCOMPARE(subject.item(0,1)->text(), QString("testValue1"));

    QCOMPARE(subject.item(1,0)->text(), QString("testKey2"));
    QCOMPARE(subject.item(1,1)->text(), QString("testValue2"));

    QCOMPARE(subject.item(2,0)->text(), QString("testKey3"));
    QCOMPARE(subject.item(2,1)->text(), QString("testValue3"));
}

void Ut_SettingsTable::testRemoveAllRows()
{
    SettingsTable subject;

    subject.appendRow(QString("testKey1"), QString("testValue1"));
    subject.appendRow(QString("testKey2"), QString("testValue2"));
    subject.appendRow(QString("testKey3"), QString("testValue3"));

    subject.removeAllRows();
    QCOMPARE(subject.rowCount(), 0);
}

void Ut_SettingsTable::testKey()
{
    SettingsTable subject;

    subject.appendRow(QString("testKey1"), QString("testValue1"));
    subject.appendRow(QString("testKey2"), QString("testValue2"));
    subject.appendRow(QString("testKey3"), QString("testValue3"));

    QCOMPARE(subject.key(0), QString("testKey1"));
    QCOMPARE(subject.key(1), QString("testKey2"));
    QCOMPARE(subject.key(2), QString("testKey3"));
}

void Ut_SettingsTable::testValue()
{
    SettingsTable subject;

    subject.appendRow(QString("testKey1"), QString("testValue1"));
    subject.appendRow(QString("testKey2"), QString("testValue2"));
    subject.appendRow(QString("testKey3"), QString("testValue3"));

    QCOMPARE(subject.value(0), QString("testValue1"));
    QCOMPARE(subject.value(1), QString("testValue2"));
    QCOMPARE(subject.value(2), QString("testValue3"));
}

QTEST_MAIN(Ut_SettingsTable)
