#ifndef _UT_REMOTELIST_H_
#define _UT_REMOTELIST_H_

#include <QObject>
#include <QStringList>
#include <QMap>
#include <QList>
#include <QDomElement>

#include "model.h"
#include "remotelist.h"

class Ut_RemoteList: public QObject
{
    Q_OBJECT

private slots:
    void initTestCase();
    void cleanupTestCase();

    void testIsValid();
    void testIsValid_setContent();
    void testLetters();
    void testManufacturers();
    void testModels();
    void testLetters_setContent();
    void testManufacturers_setContent();
    void testModels_setContent();

private:
    // Creates the xml document containing the test data
    void createDocument();

    // Creates element for each mfg which name starts with the given letter.
    void createMfgElements(QChar &letter, QDomElement &parent);
    void createModelElements(const QString &mfg, QDomElement &parent);

    void compareLetters(RemoteList &subject);
    void compareManufacturers(RemoteList &subject);
    void compareModels(RemoteList &subject);

private:
    QDomDocument document;
    QMap<QString, QStringList> validMfgs;
    QMap<QString, QList<Model> > validModels;
};

#endif // UT_REMOTELIST_H



