#include <QSettings>
#include "ut_remote.h"

#include <fstream>

#include <QtTest>
#include <QDebug>

#include "qnetworkaccessmanager.h"

#define private public
#include "remote.h"
#undef private

void reset()
{
    QNetworkAccessManager::urls.clear();
    QSettings::values.clear();
}

void Ut_Remote::initTestCase()
{
    subject = NULL;
}

void Ut_Remote::cleanupTestCase()
{
}

void Ut_Remote::init()
{
    subject = new Remote();
    reset();
}

void Ut_Remote::cleanup()
{
    if (subject != NULL) {
        delete subject;
        subject = NULL;
    }
    reset();
}

void Ut_Remote::testSaveToFile_normal()
{
    subject->m_name = "testname";
    subject->saveToFile();
    QCOMPARE(QNetworkAccessManager::urls.count(), 1);
    QCOMPARE(QNetworkAccessManager::urls[0], 
            QString("http://mercury.wipsl.com/irwi/uploaded/testname"));
    QSettings settings;
    QCOMPARE(settings.value("remoteName", "fail").toString(), 
            QString("testname"));
}

void Ut_Remote::testSaveToFile_emptyname()
{
    subject->m_name = "";
    subject->saveToFile();
    QCOMPARE(QNetworkAccessManager::urls.count(), 0);
    QSettings settings;
    QCOMPARE(settings.value("remoteName", "testname").toString(), 
            QString("testname"));
}

void Ut_Remote::testUpdateInfo()
{
}

void Ut_Remote::testSendRating()
{
}

QTEST_MAIN(Ut_Remote)


